"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../../../common/lib/kibana");
var _test_ids = require("./test_ids");
var _telemetry = require("../../../common/lib/telemetry");
var _preview_link = require("./preview_link");
var _link_utils = require("../utils/link_utils");
var _use_which_flyout = require("../../document_details/shared/hooks/use_which_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/flyout_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders a link that opens the right panel or preview panel
 * If a flyout is open, it returns the PreviewLink component
 * If a flyout is not open, the link will open the right panel
 * If the field does not have flyout, the link will not be rendered
 *
 * The flyout open determination is done via url, for expandable
 * flyout that uses in memory state, use the `isFlyoutOpen` prop.
 */
const FlyoutLink = ({
  field,
  value,
  scopeId,
  isFlyoutOpen = false,
  ruleId,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const whichFlyout = (0, _use_which_flyout.useWhichFlyout)();
  const renderPreview = isFlyoutOpen || whichFlyout !== null;
  const rightPanelParams = (0, _react.useMemo)(() => (0, _link_utils.getRightPanelParams)({
    value,
    field,
    scopeId,
    ruleId
  }), [value, field, scopeId, ruleId]);
  const onClick = (0, _react.useCallback)(() => {
    if (rightPanelParams) {
      openFlyout({
        right: {
          id: rightPanelParams.id,
          params: rightPanelParams.params
        }
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: scopeId,
        panel: 'right'
      });
    }
  }, [rightPanelParams, scopeId, telemetry, openFlyout]);

  // If the flyout is open, render the preview link
  if (renderPreview) {
    return /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
      field: field,
      value: value,
      scopeId: scopeId,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, children);
  }
  return rightPanelParams ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    "data-test-subj": dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : _test_ids.FLYOUT_LINK_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, children !== null && children !== void 0 ? children : value) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children !== null && children !== void 0 ? children : value);
};
exports.FlyoutLink = FlyoutLink;