"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicatorQueryParams = void 0;
var _esQuery = require("@kbn/es-query");
var _common = require("../../../threat_intelligence/constants/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Prepare shared `query` fields used within indicator search request
 */
const getIndicatorQueryParams = id => {
  return {
    query: (0, _esQuery.buildEsQuery)(undefined, [{
      query: _common.THREAT_QUERY_BASE,
      language: 'kuery'
    }], [{
      query: {
        id
      },
      meta: {}
    }])
  };
};
exports.getIndicatorQueryParams = getIndicatorQueryParams;