"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeader = exports.INDICATORS_FLYOUT_TITLE_TEST_ID = exports.INDICATORS_FLYOUT_SUBTITLE_TEST_ID = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _context = require("./context");
var _unwrap_value = require("../../threat_intelligence/modules/indicators/utils/unwrap_value");
var _indicator = require("../../../common/threat_intelligence/types/indicator");
var _date_formatter = require("../../threat_intelligence/components/date_formatter");
var _flyout_header_tabs = require("../shared/components/flyout_header_tabs");
var _flyout_header = require("../shared/components/flyout_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ioc_details/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INDICATORS_FLYOUT_TITLE_TEST_ID = exports.INDICATORS_FLYOUT_TITLE_TEST_ID = 'tiIndicatorFlyoutTitle';
const INDICATORS_FLYOUT_SUBTITLE_TEST_ID = exports.INDICATORS_FLYOUT_SUBTITLE_TEST_ID = 'tiIndicatorFlyoutSubtitle';
/**
 * Header of the indicator details panel flyout
 */
const PanelHeader = exports.PanelHeader = /*#__PURE__*/(0, _react.memo)(({
  selectedTabId,
  setSelectedTabId,
  tabs,
  ...flyoutHeaderProps
}) => {
  const {
    indicator
  } = (0, _context.useIOCDetailsContext)();
  const onSelectedTabChanged = (0, _react.useCallback)(id => setSelectedTabId(id), [setSelectedTabId]);
  const renderTabs = (0, _react.useMemo)(() => tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index,
    "data-test-subj": tab['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, tab.name)), [onSelectedTabChanged, selectedTabId, tabs]);
  const firstSeen = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.FirstSeen);
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, (0, _extends2.default)({}, flyoutHeaderProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": INDICATORS_FLYOUT_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyout.panelTitleWithOverviewTab",
    defaultMessage: "Indicator details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": INDICATORS_FLYOUT_SUBTITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyout.panelSubTitle",
    defaultMessage: "First seen: ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_date_formatter.DateFormatter, {
    date: firstSeen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_header_tabs.FlyoutHeaderTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, renderTabs));
});
PanelHeader.displayName = 'PanelHeader';