"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIOCDetailsContext = exports.IOCDetailsProvider = exports.IOCDetailsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _field_types_provider = require("../../threat_intelligence/containers/field_types_provider");
var _use_indicator_by_id = require("../../threat_intelligence/modules/cases/hooks/use_indicator_by_id");
var _flyout_loading = require("../shared/components/flyout_loading");
var _flyout_error = require("../shared/components/flyout_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ioc_details/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A context provider shared by the right, left and preview panels in expandable ioc details flyout
 */
const IOCDetailsContext = exports.IOCDetailsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const IOCDetailsProvider = exports.IOCDetailsProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  children
}) => {
  const {
    indicator,
    isLoading
  } = (0, _use_indicator_by_id.useIndicatorById)(id || '');
  const contextValue = (0, _react.useMemo)(() => id && indicator ? {
    id,
    indicator
  } : undefined, [id, indicator]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 12
      }
    });
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_field_types_provider.FieldTypesProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(IOCDetailsContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, children));
});
IOCDetailsProvider.displayName = 'DocumentDetailsProvider';
const useIOCDetailsContext = () => {
  const contextValue = (0, _react.useContext)(IOCDetailsContext);
  if (!contextValue) {
    throw new Error('DocumentDetailsContext can only be used within DocumentDetailsContext provider');
  }
  return contextValue;
};
exports.useIOCDetailsContext = useIOCDetailsContext;