"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedValuesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _indicator = require("../../../../common/threat_intelligence/types/indicator");
var _unwrap_value = require("../../../threat_intelligence/modules/indicators/utils/unwrap_value");
var _fields_table = require("./fields_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ioc_details/components/highlighted_values_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Pick indicator fields starting with the indicator type
 */
const byIndicatorType = (indicatorType, field) => field.startsWith(`threat.indicator.${indicatorType}`) || ['threat.indicator.reference', 'threat.indicator.description', 'threat.software.alias', 'threat.indicator.confidence', 'threat.tactic.name', 'threat.tactic.reference'].includes(field);
/**
 * Displays highlighted indicator values based on indicator type
 */
const HighlightedValuesTable = ({
  indicator,
  'data-test-subj': dataTestSubj
}) => {
  const highlightedFields = (0, _react.useMemo)(() => {
    const indicatorType = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Type);
    const sanitisedIndicatorType = !Array.isArray(indicatorType) && indicatorType || '';
    return Object.keys(indicator.fields).filter(field => byIndicatorType(sanitisedIndicatorType, field));
  }, [indicator]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_fields_table.IndicatorFieldsTable, {
    indicator: indicator,
    fields: highlightedFields,
    "data-test-subj": dataTestSubj,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
};
exports.HighlightedValuesTable = HighlightedValuesTable;