"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPreviewPanelKey = exports.UserPanel = exports.USER_PANEL_RISK_SCORE_QUERY_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_non_closed_alerts = require("../../../cloud_security_posture/hooks/use_non_closed_alerts");
var _use_refetch_query_by_id = require("../../../entity_analytics/api/hooks/use_refetch_query_by_id");
var _risk_inputs_tab = require("../../../entity_analytics/components/entity_details_flyout/tabs/risk_inputs/risk_inputs_tab");
var _use_calculate_entity_risk_score = require("../../../entity_analytics/api/hooks/use_calculate_entity_risk_score");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _managed_details = require("../../../../common/search_strategy/security_solution/users/managed_details");
var _use_managed_user = require("../shared/hooks/use_managed_user");
var _manage_query = require("../../../common/components/page/manage_query");
var _model = require("../../../explore/users/store/model");
var _get_criteria_from_users_type = require("../../../common/components/ml/criteria/get_criteria_from_users_type");
var _use_global_time = require("../../../common/containers/use_global_time");
var _anomaly_table_provider = require("../../../common/components/ml/anomaly/anomaly_table_provider");
var _search_strategy = require("../../../../common/search_strategy");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _footer = require("./footer");
var _content = require("./content");
var _header = require("./header");
var _use_observed_user = require("./hooks/use_observed_user");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _footer2 = require("../user_preview/footer");
var _types = require("../../../overview/components/detection_response/alerts_by_status/types");
var _use_navigate_to_user_details = require("./hooks/use_navigate_to_user_details");
var _types2 = require("../../../../common/entity_analytics/types");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UserPreviewPanelKey = exports.UserPreviewPanelKey = 'user-preview-panel';
const USER_PANEL_RISK_SCORE_QUERY_ID = exports.USER_PANEL_RISK_SCORE_QUERY_ID = 'userPanelRiskScoreQuery';
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const UserPanel = ({
  contextID,
  scopeId,
  userName,
  isPreviewMode = false
}) => {
  var _observedUser$details, _managedUser$data, _managedUser$data2;
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const assetInventoryEnabled = uiSettings.get(_constants.ENABLE_ASSET_INVENTORY_SETTING, true);
  const userNameFilterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const riskScoreState = (0, _use_risk_score.useRiskScore)({
    riskEntity: _types2.EntityType.user,
    filterQuery: userNameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION
  });
  const {
    inspect,
    refetch,
    loading
  } = riskScoreState;
  const {
    to,
    from,
    isInitializing,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const observedUser = (0, _use_observed_user.useObservedUser)(userName, scopeId);
  const email = (_observedUser$details = observedUser.details.user) === null || _observedUser$details === void 0 ? void 0 : _observedUser$details.email;
  const managedUser = (0, _use_managed_user.useManagedUser)();
  const {
    data: userRisk
  } = riskScoreState;
  const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
  const isRiskScoreExist = !!(userRiskData !== null && userRiskData !== void 0 && userRiskData.user.risk);
  const refetchRiskInputsTab = (0, _use_refetch_query_by_id.useRefetchQueryById)(_risk_inputs_tab.RISK_INPUTS_TAB_QUERY_ID);
  const refetchRiskScore = (0, _react.useCallback)(() => {
    refetch();
    refetchRiskInputsTab === null || refetchRiskInputsTab === void 0 ? void 0 : refetchRiskInputsTab();
  }, [refetch, refetchRiskInputsTab]);
  const {
    isLoading: recalculatingScore,
    calculateEntityRiskScore
  } = (0, _use_calculate_entity_risk_score.useCalculateEntityRiskScore)(_types2.EntityType.user, userName, {
    onSuccess: refetchRiskScore
  });
  const {
    hasMisconfigurationFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)('user.name', userName);
  const {
    hasNonClosedAlerts
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field: _types2.EntityIdentifierFields.userName,
    value: userName,
    to,
    from,
    queryId: `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}USER_NAME_RIGHT`
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    loading,
    queryId: USER_PANEL_RISK_SCORE_QUERY_ID,
    refetch,
    setQuery
  });
  const openDetailsPanel = (0, _use_navigate_to_user_details.useNavigateToUserDetails)({
    userName,
    email,
    scopeId,
    contextID,
    isRiskScoreExist,
    hasMisconfigurationFindings,
    hasNonClosedAlerts,
    isPreviewMode
  });
  const openPanelFirstTab = (0, _react.useCallback)(() => openDetailsPanel({
    tab: isRiskScoreExist ? _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS : _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS
  }), [isRiskScoreExist, openDetailsPanel]);
  const hasUserDetailsData = !!(userRiskData !== null && userRiskData !== void 0 && userRiskData.user.risk) || !!((_managedUser$data = managedUser.data) !== null && _managedUser$data !== void 0 && _managedUser$data[_managed_details.ManagedUserDatasetKey.OKTA]) || !!((_managedUser$data2 = managedUser.data) !== null && _managedUser$data2 !== void 0 && _managedUser$data2[_managed_details.ManagedUserDatasetKey.ENTRA]);
  if (observedUser.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model.UsersType.details, userName),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => {
    const observedUserWithAnomalies = {
      ...observedUser,
      anomalies: {
        isLoading: isLoadingAnomaliesData,
        anomalies: anomaliesData,
        jobNameById
      }
    };
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
      flyoutIsExpandable: hasUserDetailsData || hasMisconfigurationFindings || hasNonClosedAlerts,
      expandDetails: openPanelFirstTab,
      isPreviewMode: isPreviewMode,
      isRulePreview: scopeId === _securitysolutionDataTable.TableId.rulePreview,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_header.UserPanelHeader, {
      userName: userName,
      observedUser: observedUserWithAnomalies,
      managedUser: managedUser,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_content.UserPanelContent, {
      userName: userName,
      observedUser: observedUserWithAnomalies,
      riskScoreState: riskScoreState,
      recalculatingScore: recalculatingScore,
      onAssetCriticalityChange: calculateEntityRiskScore,
      contextID: contextID,
      scopeId: scopeId,
      openDetailsPanel: openDetailsPanel,
      isPreviewMode: isPreviewMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }), !isPreviewMode && assetInventoryEnabled && /*#__PURE__*/_react.default.createElement(_footer.UserPanelFooter, {
      userName: userName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 57
      }
    }), isPreviewMode && /*#__PURE__*/_react.default.createElement(_footer2.UserPreviewPanelFooter, {
      userName: userName,
      contextID: contextID,
      scopeId: scopeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 15
      }
    }));
  });
};
exports.UserPanel = UserPanel;
UserPanel.displayName = 'UserPanel';