"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedUserAccordion = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _left_panel_header = require("../../shared/components/left_panel/left_panel_header");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _formatted_date = require("../../../../common/components/formatted_date");
var _constants = require("../../shared/constants");
var _model = require("../../../../explore/users/store/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/components/managed_user_accordion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManagedUserAccordion = ({
  children,
  title,
  managedUser,
  tableType,
  openDetailsPanel,
  isPreviewMode
}) => {
  const xsFontSize = (0, _eui.useEuiFontSize)('xxs').fontSize;
  const timestamp = (0, _fp.get)('@timestamp[0]', managedUser);
  const goToEntityInsightTab = (0, _react.useCallback)(() => openDetailsPanel({
    tab: tableType === _model.UserAssetTableType.assetOkta ? _left_panel_header.EntityDetailsLeftPanelTab.OKTA : _left_panel_header.EntityDetailsLeftPanelTab.ENTRA
  }), [openDetailsPanel, tableType]);
  const link = (0, _react.useMemo)(() => ({
    callback: goToEntityInsightTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.showAssetDocument",
      defaultMessage: "Show asset details",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    })
  }), [goToEntityInsightTab]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    "data-test-subj": `managed-user-accordion-${tableType}`,
    header: {
      title,
      iconType: !isPreviewMode ? 'arrowStart' : undefined,
      headerContent: timestamp && /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _react2.css)`
              font-size: ${xsFontSize};
            `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.timeline.userDetails.updatedTime",
        defaultMessage: "Updated {time}",
        values: {
          time: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: timestamp,
            dateFormat: "MMM D, YYYY",
            relativeThresholdInHrs: _constants.ONE_WEEK_IN_HOURS,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 82,
              columnNumber: 19
            }
          })
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 13
        }
      })),
      link
    },
    expand: {
      expandable: false
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, children);
};
exports.ManagedUserAccordion = ManagedUserAccordion;