"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FLYOUT_BODY_TEST_ID = exports.EasePanel = exports.ATTACK_DISCOVERY_SECTION_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _helpers = require("../../assistant/helpers");
var _ai_assistant_section = require("./components/ai_assistant_section");
var _attack_discovery_section = require("./components/attack_discovery_section");
var _alert_summary_section = require("./components/alert_summary_section");
var _highlighted_fields = require("../document_details/right/components/highlighted_fields");
var _context = require("./context");
var _flyout_body = require("../shared/components/flyout_body");
var _flyout_navigation = require("../shared/components/flyout_navigation");
var _footer = require("./footer");
var _flyout_header = require("../shared/components/flyout_header");
var _header_title = require("./components/header_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FLYOUT_BODY_TEST_ID = exports.FLYOUT_BODY_TEST_ID = 'ease-alert-flyout-body';
const ATTACK_DISCOVERY_SECTION_TEST_ID = exports.ATTACK_DISCOVERY_SECTION_TEST_ID = 'ease-alert-flyout-attack-discovery-section';

/**
 * Panel to be displayed in EASE alert summary flyout
 */
const EasePanel = exports.EasePanel = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    investigationFields
  } = (0, _context.useEaseDetailsContext)();
  const getPromptContext = (0, _react.useCallback)(async () => (0, _helpers.getRawData)(dataFormattedForFieldBrowser), [dataFormattedForFieldBrowser]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_title.HeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    "data-test-subj": FLYOUT_BODY_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_summary_section.AlertSummarySection, {
    getPromptContext: getPromptContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_highlighted_fields.HighlightedFields, {
    dataFormattedForFieldBrowser: dataFormattedForFieldBrowser,
    investigationFields: investigationFields,
    showCellActions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_attack_discovery_section.AttackDiscoverySection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_ai_assistant_section.AIAssistantSection, {
    getPromptContext: getPromptContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_footer.PanelFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
});
EasePanel.displayName = 'EasePanel';