"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationIcon = exports.INTEGRATION_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _integration_icon = require("../../../detections/components/alert_summary/common/integration_icon");
var _use_fetch_integrations = require("../../../detections/hooks/alert_summary/use_fetch_integrations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/integration_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INTEGRATION_TEST_ID = exports.INTEGRATION_TEST_ID = 'alert-summary-flyout';
/**
 * Renders the icon for the integration that matches the rule id.
 * It fetches all the packages (integrations) to find the matching integration name.
 * In EASE, we can retrieve the integration/package via the kibana.rule.parameters field on the alert.
 */
const IntegrationIcon = exports.IntegrationIcon = /*#__PURE__*/(0, _react.memo)(({
  integrationName
}) => {
  const {
    installedPackages,
    isLoading: integrationIsLoading
  } = (0, _use_fetch_integrations.useFetchIntegrations)();
  const integration = installedPackages.find(p => integrationName === p.name);
  return /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": INTEGRATION_TEST_ID,
    iconSize: "l",
    integration: integration,
    isLoading: integrationIsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
});
IntegrationIcon.displayName = 'IntegrationIcon';