"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToLeftPanel = void 0;
var _react = require("react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _types = require("../../../../common/lib/telemetry/types");
var _kibana = require("../../../../common/lib/kibana");
var _panel_keys = require("../constants/panel_keys");
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns a callback to navigate to the analyzer in the flyout
 */
const useNavigateToLeftPanel = ({
  tab,
  subTab
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const right = (0, _react.useMemo)(() => ({
    id: _panel_keys.DocumentDetailsRightPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    }
  }), [eventId, indexName, scopeId]);
  const left = (0, _react.useMemo)(() => ({
    id: _panel_keys.DocumentDetailsLeftPanelKey,
    params: {
      id: eventId,
      indexName,
      scopeId
    },
    path: {
      tab,
      subTab
    }
  }), [eventId, indexName, scopeId, tab, subTab]);
  return (0, _react.useCallback)(() => {
    if (!isPreviewMode) {
      openLeftPanel(left);
      telemetry.reportEvent(_types.DocumentEventTypes.DetailsFlyoutTabClicked, {
        location: scopeId,
        panel: 'left',
        tabId: tab
      });
    } else {
      openFlyout({
        right,
        left
      });
      telemetry.reportEvent(_types.DocumentEventTypes.DetailsFlyoutOpened, {
        location: scopeId,
        panel: 'left'
      });
    }
  }, [openFlyout, openLeftPanel, right, left, scopeId, telemetry, isPreviewMode, tab]);
};
exports.useNavigateToLeftPanel = useNavigateToLeftPanel;