"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionViewNoDataMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/session_view_no_data_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Message displayed when the user does not have access to Session View
 */
const SessionViewNoDataMessage = ({
  isEnterprisePlus,
  hasSessionViewConfig
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return !isEnterprisePlus ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_UPSELL_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: 'xpack.securitySolution.flyout.sessionViewer.upsellDescription',
    defaultMessage: "This feature requires an {subscription}",
    values: {
      subscription: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/pricing/",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: 'xpack.securitySolution.flyout.sessionViewer.upsellLinkText',
        defaultMessage: "Enterprise subscription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  })) : !hasSessionViewConfig ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.SESSION_VIEW_NO_DATA_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: 'xpack.securitySolution.flyout.sessionViewer.noDataDescription',
    defaultMessage: "You can only view Linux session details if you\u2019ve enabled the {setting} setting in your Elastic Defend integration policy. Refer to {link} for more information.",
    values: {
      setting: /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _css.css)`
                font-weight: ${euiTheme.font.weight.bold};
              `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: 'xpack.securitySolution.flyout.sessionViewer.noDataSettingDescription',
        defaultMessage: "Include session data",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 15
        }
      })),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/session-view.html#enable-session-view",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: 'xpack.securitySolution.flyout.sessionViewer.noDataLinkText',
        defaultMessage: "Enable Session View data",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  })) : null;
};
exports.SessionViewNoDataMessage = SessionViewNoDataMessage;
SessionViewNoDataMessage.displayName = 'SessionViewNoDataMessage';