"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedAlertStats = exports.AlertCountInsight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _insight_distribution_bar = require("./insight_distribution_bar");
var _helpers = require("../../../../detections/components/alerts_kpis/severity_level_panel/helpers");
var _formatted_number = require("../../../../common/components/formatted_number");
var _types = require("../../../../../common/types");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _use_alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status/use_alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _types2 = require("../../../../overview/components/detection_response/alerts_by_status/types");
var _test_ids = require("./test_ids");
var _left_panel_header = require("../../../entity_details/shared/components/left_panel/left_panel_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/alert_count_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ORDER = ['Low', 'Medium', 'High', 'Critical'];
/**
 * Filters closed alerts and format the alert stats for the distribution bar
 */
const getFormattedAlertStats = (alertsData, euiTheme) => {
  const severityMap = new Map();
  const filteredAlertsData = alertsData ? Object.fromEntries(Object.entries(alertsData).filter(([key]) => key !== _types.FILTER_CLOSED)) : {};
  Object.keys(filteredAlertsData || {}).forEach(status => {
    var _filteredAlertsData$s;
    if (filteredAlertsData !== null && filteredAlertsData !== void 0 && (_filteredAlertsData$s = filteredAlertsData[status]) !== null && _filteredAlertsData$s !== void 0 && _filteredAlertsData$s.severities) {
      var _filteredAlertsData$s2;
      filteredAlertsData === null || filteredAlertsData === void 0 ? void 0 : (_filteredAlertsData$s2 = filteredAlertsData[status]) === null || _filteredAlertsData$s2 === void 0 ? void 0 : _filteredAlertsData$s2.severities.forEach(severity => {
        const currentSeverity = severityMap.get(severity.key) || 0;
        severityMap.set(severity.key, currentSeverity + severity.value);
      });
    }
  });
  const alertStats = Array.from(severityMap, ([key, count]) => ({
    key: (0, _lodash.capitalize)(key),
    count,
    color: (0, _helpers.getSeverityColor)(key, euiTheme)
  })).sort((a, b) => {
    const aIndex = ORDER.indexOf(a.key);
    const bIndex = ORDER.indexOf(b.key);
    return aIndex - bIndex;
  });
  return alertStats;
};

/*
 * Displays a distribution bar with the total alert count for a given entity
 */
exports.getFormattedAlertStats = getFormattedAlertStats;
const AlertCountInsight = ({
  name,
  fieldName,
  direction,
  openDetailsPanel,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const entityFilter = (0, _react.useMemo)(() => ({
    field: fieldName,
    value: name
  }), [fieldName, name]);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    items,
    isLoading
  } = (0, _use_alerts_by_status.useAlertsByStatus)({
    entityFilter,
    signalIndexName,
    queryId: _types2.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID,
    to,
    from
  });
  const alertStats = (0, _react.useMemo)(() => getFormattedAlertStats(items, euiTheme), [items, euiTheme]);
  const totalAlertCount = (0, _react.useMemo)(() => alertStats.reduce((acc, item) => acc + item.count, 0), [alertStats]);
  const alertCount = (0, _react.useMemo)(() => {
    const formattedAlertCount = /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: totalAlertCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 33
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.insights.alert.alertCountTooltip",
        defaultMessage: "Opens {count, plural, one {this alert} other {these alerts}} in a new flyout",
        values: {
          count: totalAlertCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": _test_ids.INSIGHTS_ALERTS_COUNT_NAVIGATION_BUTTON_TEST_ID,
      onClick: () => openDetailsPanel({
        tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
        subTab: _left_panel_header.CspInsightLeftPanelSubTab.ALERTS
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, formattedAlertCount));
  }, [totalAlertCount, openDetailsPanel]);
  if (!isLoading && totalAlertCount === 0) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": `${dataTestSubj}-loading-spinner`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_insight_distribution_bar.InsightDistributionBar, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.insights.alertCountTitle",
      defaultMessage: "Alerts:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }),
    stats: alertStats,
    count: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": `${dataTestSubj}-count`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 18
      }
    }, alertCount),
    direction: direction,
    "data-test-subj": `${dataTestSubj}-distribution-bar`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }));
};
exports.AlertCountInsight = AlertCountInsight;
AlertCountInsight.displayName = 'AlertCountInsight';