"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionPreview = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _use_rule_details_link = require("../../shared/hooks/use_rule_details_link");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _formatted_date = require("../../../../common/components/formatted_date");
var _use_process_data = require("../hooks/use_process_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/session_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * One-off helper to make sure that inline values are rendered consistently
 */
const ValueContainer = ({
  text,
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, text && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement("span", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 9
  }
}, text), "\xA0"), children);

/**
 * Renders session preview under Visualizations section in the flyout right EuiPanel
 */
const SessionPreview = () => {
  const {
    isRulePreview
  } = (0, _context.useDocumentDetailsContext)();
  const {
    processName,
    userName,
    startAt,
    ruleName,
    ruleId,
    workdir,
    command
  } = (0, _use_process_data.useProcessData)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const emphasisStyles = (0, _react.useMemo)(() => ({
    fontWeight: euiTheme.font.weight.bold
  }), [euiTheme.font.weight.bold]);
  const processNameFragment = (0, _react.useMemo)(() => {
    return processName && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.processDescription",
        defaultMessage: "started",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: emphasisStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, processName));
  }, [emphasisStyles, processName]);
  const timeFragment = (0, _react.useMemo)(() => {
    return startAt && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.timeDescription",
        defaultMessage: "at",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(startAt),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    })));
  }, [startAt]);
  const href = (0, _use_rule_details_link.useRuleDetailsLink)({
    ruleId: !isRulePreview ? ruleId : null
  });
  const ruleFragment = (0, _react.useMemo)(() => {
    return ruleName && ruleId && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.ruleDescription",
        defaultMessage: "with rule",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, href ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: href,
      target: "_blank",
      "data-test-subj": _test_ids.SESSION_PREVIEW_RULE_DETAILS_LINK_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, ruleName) : /*#__PURE__*/_react.default.createElement(ValueContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    }, ruleName));
  }, [ruleName, ruleId, href]);
  const commandFragment = (0, _react.useMemo)(() => {
    return command && /*#__PURE__*/_react.default.createElement(ValueContainer, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.commandDescription",
        defaultMessage: "by",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, workdir, " ", command));
  }, [command, workdir]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        line-height: 1.5;
      `,
    "data-test-subj": _test_ids.SESSION_PREVIEW_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ValueContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "user",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }), "\xA0", /*#__PURE__*/_react.default.createElement("span", {
    css: emphasisStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, userName)), processNameFragment, timeFragment, ruleFragment, commandFragment);
};
exports.SessionPreview = SessionPreview;