"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventHeaderTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _flyout_title = require("../../../shared/components/flyout_title");
var _severity = require("./severity");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _context = require("../../shared/context");
var _formatted_date = require("../../../../common/components/formatted_date");
var _test_ids = require("./test_ids");
var _utils = require("../../shared/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/event_header_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Event details flyout right section header
 */
const EventHeaderTitle = exports.EventHeaderTitle = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser,
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const {
    timestamp
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const eventCategory = (0, _utils.getField)(getFieldsData('event.category'));
  const title = (0, _react.useMemo)(() => (0, _utils.getEventTitle)({
    eventKind,
    eventCategory,
    getFieldsData
  }), [eventKind, eventCategory, getFieldsData]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_severity.DocumentSeverity, {
    getFieldsData: getFieldsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), timestamp && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: title,
    iconType: 'analyzeEvent',
    "data-test-subj": _test_ids.FLYOUT_EVENT_HEADER_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
});
EventHeaderTitle.displayName = 'EventHeaderTitle';