"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useThreatIntelligenceDetails = void 0;
var _react = require("react");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _constants = require("../../../../data_view_manager/constants");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _threat_intelligence = require("../../shared/utils/threat_intelligence");
var _use_investigation_enrichment = require("../../shared/hooks/use_investigation_enrichment");
var _details = require("../../../../timelines/containers/details");
var _containers = require("../../../../sourcerer/containers");
var _use_route_spy = require("../../../../common/utils/route/use_route_spy");
var _context = require("../../shared/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A hook that returns data necessary strictly to render Threat Intel Insights.
 * Reusing a bunch of hooks scattered across kibana, it makes it easier to mock the data layer
 * for component testing.
 */
const useThreatIntelligenceDetails = () => {
  const {
    indexName,
    eventId
  } = (0, _context.useDocumentDetailsContext)();
  const [{
    pageName
  }] = (0, _use_route_spy.useRouteSpy)();
  const sourcererScope = pageName === _deeplinksSecurity.SecurityPageName.detections ? _constants.PageScope.alerts : _constants.PageScope.default;
  const sourcererDataView = (0, _containers.useSourcererDataView)(sourcererScope);
  const [isEventDataLoading, eventData] = (0, _details.useTimelineEventsDetails)({
    indexName,
    eventId,
    runtimeMappings: sourcererDataView.sourcererDataView.runtimeFieldMap,
    skip: !eventId
  });
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(eventData);
  const data = (0, _react.useMemo)(() => eventData || [], [eventData]);
  const eventFields = (0, _react.useMemo)(() => (0, _threat_intelligence.getEnrichmentFields)(data || []), [data]);
  const {
    result: enrichmentsResponse,
    loading: isEnrichmentsLoading,
    setRange,
    range
  } = (0, _use_investigation_enrichment.useInvestigationTimeEnrichment)({
    eventFields
  });
  const existingEnrichments = (0, _react.useMemo)(() => isAlert ? (0, _threat_intelligence.parseExistingEnrichments)(data).map(enrichmentData => (0, _threat_intelligence.timelineDataToEnrichment)(enrichmentData)) : [], [data, isAlert]);
  const allEnrichments = (0, _react.useMemo)(() => {
    if (isEnrichmentsLoading || !(enrichmentsResponse !== null && enrichmentsResponse !== void 0 && enrichmentsResponse.enrichments)) {
      return existingEnrichments;
    }
    return (0, _threat_intelligence.filterDuplicateEnrichments)([...existingEnrichments, ...enrichmentsResponse.enrichments]);
  }, [isEnrichmentsLoading, enrichmentsResponse, existingEnrichments]);
  const isLoading = isEnrichmentsLoading || isEventDataLoading;
  return {
    enrichments: allEnrichments,
    eventFields,
    isEnrichmentsLoading,
    isEventDataLoading,
    isLoading,
    range,
    setRange
  };
};
exports.useThreatIntelligenceDetails = useThreatIntelligenceDetails;