"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableTabItems = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the sorted items for the table tab
 */
const getTableTabItems = ({
  dataFormattedForFieldBrowser,
  fieldsByName
}) => {
  const sortedItems = (0, _fp.sortBy)(['field'], dataFormattedForFieldBrowser).map((item, i) => ({
    ...item,
    ...fieldsByName[item.field],
    valuesConcatenated: item.values != null ? item.values.join() : '',
    ariaRowindex: i + 1
  }));
  return sortedItems;
};
exports.getTableTabItems = getTableTabItems;