"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _context = require("../context");
var _table_tab_columns = require("../utils/table_tab_columns");
var _test_ids = require("./test_ids");
var _table_tab_items = require("../utils/table_tab_items");
var _source = require("../../../common/containers/source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/attack_details/tabs/table_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.attackDetailsFlyout.table.filterPlaceholderLabel', {
  defaultMessage: 'Filter by field or value...'
});

/**
 * Defines the behavior of the search input that appears above the table of data
 */
const SEARCH_CONFIG = {
  box: {
    incremental: true,
    placeholder: PLACEHOLDER,
    schema: true,
    'data-test-subj': _test_ids.TABLE_TAB_SEARCH_INPUT_TEST_ID
  }
};

/**
 * Pagination options for the table
 */
const COUNT_PER_PAGE_OPTIONS = [25, 50, 100];

/**
 * Table view displayed in the attack details panel Table tab
 */
const TableTab = exports.TableTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    browserFields,
    dataFormattedForFieldBrowser
  } = (0, _context.useAttackDetailsContext)();
  const smallFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  const onTableChange = (0, _react.useCallback)(({
    page: {
      index
    }
  }) => setPagination({
    pageIndex: index
  }), []);
  const paginationSettings = (0, _react.useMemo)(() => ({
    ...pagination,
    pageSizeOptions: COUNT_PER_PAGE_OPTIONS
  }), [pagination]);
  const columns = (0, _react.useMemo)(() => (0, _table_tab_columns.getTableTabColumns)(), []);
  const items = (0, _react.useMemo)(() => (0, _table_tab_items.getTableTabItems)({
    dataFormattedForFieldBrowser,
    fieldsByName: (0, _source.getAllFieldsByName)(browserFields)
  }), [browserFields, dataFormattedForFieldBrowser]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    itemId: "field",
    columns: columns,
    search: SEARCH_CONFIG,
    pagination: paginationSettings,
    onTableChange: onTableChange,
    sorting: false,
    "data-test-subj": _test_ids.TABLE_TAB_CONTENT_TEST_ID,
    css: (0, _react2.css)`
        .euiTableRow {
          font-size: ${smallFontSize};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
});
TableTab.displayName = 'TableTab';