"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _asset_criticality = require("../../../../entity_analytics/components/asset_criticality");
var _formatted_date = require("../../../../common/components/formatted_date");
var _links = require("../../../../common/components/links");
var _empty_value = require("../../../../common/components/empty_value");
var _paginated_table = require("../../../components/paginated_table");
var _helpers = require("../../../../common/components/tables/helpers");
var _use_selector = require("../../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("./translations"));
var _store = require("../../store");
var _common = require("../../../../entity_analytics/components/severity/common");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _translations2 = require("../../../../entity_analytics/components/user_risk_score_table/translations");
var _types = require("../../../../app/types");
var _model = require("../../store/model");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/components/all_users/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableType = _store.usersModel.UsersTableType.allUsers;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const getUsersColumns = (showRiskColumn, dispatchSeverityUpdate) => {
  const columns = [{
    field: 'name',
    name: i18n.USER_NAME,
    truncateText: false,
    sortable: true,
    mobileOptions: {
      show: true
    },
    render: name => name != null && name.length > 0 ? (0, _helpers.getRowItemsWithActions)({
      fieldName: 'user.name',
      values: [name],
      idPrefix: `users-table-${name}-name`,
      render: item => /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
        userName: item,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 33
        }
      })
    }) : (0, _empty_value.getOrEmptyTagFromValue)(name)
  }, {
    field: 'lastSeen',
    name: i18n.LAST_SEEN,
    sortable: true,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    render: lastSeen => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
      value: lastSeen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 29
      }
    })
  }, {
    field: 'domain',
    name: i18n.DOMAIN,
    sortable: false,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    render: domain => domain != null && domain.length > 0 ? (0, _helpers.getRowItemsWithActions)({
      fieldName: 'user.domain',
      values: [domain],
      idPrefix: `users-table-${domain}-domain`
    }) : (0, _empty_value.getOrEmptyTagFromValue)(domain)
  }];
  if (showRiskColumn) {
    columns.push({
      field: 'risk',
      name: i18n.USER_RISK,
      truncateText: false,
      mobileOptions: {
        show: true
      },
      sortable: false,
      render: riskScore => {
        if (riskScore != null) {
          return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
            toolTipContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              onClick: () => dispatchSeverityUpdate(riskScore),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 136,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
              size: "xs",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 137,
                columnNumber: 19
              }
            }, (0, _translations2.VIEW_USERS_BY_SEVERITY)(riskScore.toLowerCase()))),
            severity: riskScore,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 134,
              columnNumber: 13
            }
          });
        }
        return (0, _empty_value.getEmptyTagValue)();
      }
    });
  }
  columns.push({
    field: 'criticality',
    name: i18n.ASSET_CRITICALITY,
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: false,
    render: assetCriticality => {
      if (!assetCriticality) return (0, _empty_value.getEmptyTagValue)();
      return /*#__PURE__*/_react.default.createElement(_asset_criticality.AssetCriticalityBadge, {
        criticalityLevel: assetCriticality,
        css: {
          verticalAlign: 'middle'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 9
        }
      });
    }
  });
  return columns;
};
const UsersTableComponent = ({
  users,
  totalCount,
  type,
  id,
  fakeTotalCount,
  loading,
  loadPage,
  showMorePagesIndicator,
  sort,
  setQuerySkip
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getUsersSelector = (0, _react.useMemo)(() => _store.usersSelectors.allUsersSelector(), []);
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getUsersSelector(state));
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const updateLimitPagination = (0, _react.useCallback)(newLimit => {
    dispatch(_store.usersActions.updateTableLimit({
      usersType: type,
      limit: newLimit,
      tableType
    }));
  }, [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => {
    dispatch(_store.usersActions.updateTableActivePage({
      activePage: newPage,
      usersType: type,
      tableType
    }));
  }, [type, dispatch]);
  const onSort = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newSort = criteria.sort;
      if (newSort.direction !== sort.direction || newSort.field !== sort.field) {
        dispatch(_store.usersActions.updateTableSorting({
          sort: newSort,
          tableType
        }));
      }
    }
  }, [dispatch, sort]);
  const dispatchSeverityUpdate = (0, _react.useCallback)(s => {
    dispatch(_store.usersActions.updateUserRiskScoreSeverityFilter({
      severitySelection: [s]
    }));
    navigateTo({
      deepLinkId: _types.SecurityPageName.users,
      path: _model.UsersTableType.risk
    });
  }, [dispatch, navigateTo]);
  const columns = (0, _react.useMemo)(() => getUsersColumns(isPlatinumOrTrialLicense, dispatchSeverityUpdate), [isPlatinumOrTrialLicense, dispatchSeverityUpdate]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.USERS,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    pageOfItems: users,
    showMorePagesIndicator: showMorePagesIndicator,
    totalCount: fakeTotalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage,
    sorting: sort,
    onChange: onSort,
    setQuerySkip: setQuerySkip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 5
    }
  });
};
UsersTableComponent.displayName = 'UsersTableComponent';
const UsersTable = exports.UsersTable = /*#__PURE__*/_react.default.memo(UsersTableComponent);