"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlag = exports.CountryFlagAndName = exports.CountryFlag = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18nIsoCountries = _interopRequireDefault(require("i18n-iso-countries"));
var _en = _interopRequireDefault(require("i18n-iso-countries/langs/en.json"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/country_flag.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Fixes vertical alignment of the flag
const FlagWrapper = _styled.default.span`
  position: relative;
  top: 1px;
`;

/**
 * Returns the flag for the specified country code, or null if the specified
 * country code could not be converted
 * Example: `US` -> 🇺🇸
 */
const getFlag = countryCode => countryCode && countryCode.length === 2 ? countryCode.toUpperCase().replace(/./g, c => String.fromCharCode(55356, 56741 + c.charCodeAt(0))) : null;

/** Renders an emoji flag for the specified country code */
exports.getFlag = getFlag;
const CountryFlag = exports.CountryFlag = /*#__PURE__*/(0, _react.memo)(({
  countryCode,
  displayCountryNameOnHover = false
}) => {
  (0, _react.useEffect)(() => {
    if (displayCountryNameOnHover && (0, _fp.isEmpty)(_i18nIsoCountries.default.getNames('en'))) {
      _i18nIsoCountries.default.registerLocale(_en.default);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const flag = getFlag(countryCode);
  if (flag !== null) {
    return displayCountryNameOnHover ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18nIsoCountries.default.getName(countryCode, 'en'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }, flag)) : /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, flag);
  }
  return null;
});
CountryFlag.displayName = 'CountryFlag';

/** Renders an emoji flag with country name for the specified country code */
const CountryFlagAndName = exports.CountryFlagAndName = /*#__PURE__*/(0, _react.memo)(({
  countryCode,
  displayCountryNameOnHover = false
}) => {
  const [localesLoaded, setLocalesLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if ((0, _fp.isEmpty)(_i18nIsoCountries.default.getNames('en'))) {
      _i18nIsoCountries.default.registerLocale(_en.default);
    }
    setLocalesLoaded(true);
  }, []);
  const flag = getFlag(countryCode);
  if (flag !== null && localesLoaded) {
    return displayCountryNameOnHover ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18nIsoCountries.default.getName(countryCode, 'en'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, flag)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, flag), ` ${_i18nIsoCountries.default.getName(countryCode, 'en')}`);
  }
  return null;
});
CountryFlagAndName.displayName = 'CountryFlagAndName';