"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlowTargetSelectConnectedComponent = exports.FlowTargetSelectConnected = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var i18nIp = _interopRequireWildcard(require("../details/translations"));
var _flow_target_select = require("../flow_controls/flow_target_select");
var _field_renderers = require("../field_renderers/field_renderers");
var _search_strategy = require("../../../../../common/search_strategy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/flow_target_select_connected/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectTypeItem = (0, _styled.default)(_eui.EuiFlexItem)`
  min-width: 180px;
`;
SelectTypeItem.displayName = 'SelectTypeItem';
const getUpdatedFlowTargetPath = (location, currentFlowTarget, newFlowTarget) => {
  const newPathame = location.pathname.replace(currentFlowTarget, newFlowTarget);
  return `${newPathame}${location.search}`;
};
const FlowTargetSelectConnectedComponent = ({
  flowTarget
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const updateNetworkDetailsFlowTarget = (0, _react.useCallback)(newFlowTarget => {
    const newPath = getUpdatedFlowTargetPath(location, flowTarget, newFlowTarget);
    history.push(newPath);
  }, [history, location, flowTarget]);
  return /*#__PURE__*/_react.default.createElement(SelectTypeItem, {
    grow: false,
    "data-test-subj": `${_field_renderers.IpOverviewId}-select-flow-target`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_flow_target_select.FlowTargetSelect, {
    id: _field_renderers.IpOverviewId,
    isLoading: !flowTarget,
    selectedDirection: _search_strategy.FlowDirection.uniDirectional,
    selectedTarget: flowTarget,
    displayTextOverride: [i18nIp.AS_SOURCE, i18nIp.AS_DESTINATION],
    updateFlowTargetAction: updateNetworkDetailsFlowTarget,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
};
exports.FlowTargetSelectConnectedComponent = FlowTargetSelectConnectedComponent;
const FlowTargetSelectConnected = exports.FlowTargetSelectConnected = /*#__PURE__*/_react.default.memo(FlowTargetSelectConnectedComponent);