"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlowTargetSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/flow_controls/flow_target_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const toggleTargetOptions = (id, displayText) => [{
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.source}`,
  value: _search_strategy.FlowTarget.source,
  inputDisplay: displayText[0] || i18n.SOURCE,
  directions: [_search_strategy.FlowDirection.uniDirectional, _search_strategy.FlowDirection.biDirectional]
}, {
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.destination}`,
  value: _search_strategy.FlowTarget.destination,
  inputDisplay: displayText[1] || i18n.DESTINATION,
  directions: [_search_strategy.FlowDirection.uniDirectional, _search_strategy.FlowDirection.biDirectional]
}, {
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.client}`,
  value: _search_strategy.FlowTarget.client,
  inputDisplay: displayText[2] || i18n.CLIENT,
  directions: [_search_strategy.FlowDirection.biDirectional]
}, {
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.server}`,
  value: _search_strategy.FlowTarget.server,
  inputDisplay: displayText[3] || i18n.SERVER,
  directions: [_search_strategy.FlowDirection.biDirectional]
}];
const FlowTargetSelectComponent = ({
  id,
  isLoading = false,
  selectedDirection,
  selectedTarget,
  displayTextOverride = [],
  updateFlowTargetAction
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
  options: selectedDirection ? toggleTargetOptions(id, displayTextOverride).filter(option => option.directions.includes(selectedDirection)) : toggleTargetOptions(id, displayTextOverride),
  valueOfSelected: selectedTarget,
  onChange: updateFlowTargetAction,
  isLoading: isLoading,
  "aria-label": i18n.FLOW_TARGET,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 3
  }
});
const FlowTargetSelect = exports.FlowTargetSelect = /*#__PURE__*/_react.default.memo(FlowTargetSelectComponent);