"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityStoreManagementPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _asset_criticality = require("../../../common/entity_analytics/asset_criticality");
var _kibana = require("../../common/lib/kibana");
var _asset_criticality_file_uploader = require("../components/asset_criticality_file_uploader/asset_criticality_file_uploader");
var _use_asset_criticality = require("../components/asset_criticality/use_asset_criticality");
var _helper_hooks = require("../../helper_hooks");
var _use_entity_store = require("../components/entity_store/hooks/use_entity_store");
var _use_entity_engine_privileges = require("../components/entity_store/hooks/use_entity_engine_privileges");
var _entity_store_missing_privileges_callout = require("../components/entity_store/components/entity_store_missing_privileges_callout");
var _engines_status = require("../components/entity_store/components/engines_status");
var _use_enabled_entity_types = require("../hooks/use_enabled_entity_types");
var _entity_store_error_callout = require("../components/entity_store/components/entity_store_error_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/pages/entity_store_management_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var TabId = /*#__PURE__*/function (TabId) {
  TabId["Import"] = "import";
  TabId["Status"] = "status";
  return TabId;
}(TabId || {});
const isSwitchLoading = status => status === 'installing';
const isSwitchDisabled = status => status === 'error' || isSwitchLoading(status);
const isEntityStoreEnabled = status => status === 'running';
const canDeleteEntityEngine = status => !['not_installed', 'installing'].includes(status || '');
const isEntityStoreInstalled = status => status && status !== 'not_installed';
const entityStoreLabel = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.entityStoreManagementPage.title', {
  defaultMessage: 'Entity store'
});
const EntityStoreManagementPage = () => {
  var _entityStoreStatus$da3, _entityStoreStatus$da4, _entityStoreStatus$da5, _entityStoreStatus$da6, _entityStoreStatus$da7, _entityStoreStatus$da8, _entityStoreStatus$da9;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const isEntityStoreFeatureFlagDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('entityStoreDisabled');
  const {
    data: assetCriticalityPrivileges,
    error: assetCriticalityPrivilegesError,
    isLoading: assetCriticalityIsLoading
  } = (0, _use_asset_criticality.useAssetCriticalityPrivileges)('AssetCriticalityUploadPage');
  const hasAssetCriticalityWritePermissions = assetCriticalityPrivileges === null || assetCriticalityPrivileges === void 0 ? void 0 : assetCriticalityPrivileges.has_write_permissions;
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(TabId.Import);
  const entityStoreStatus = (0, _use_entity_store.useEntityStoreStatus)({});
  const entityTypes = (0, _use_enabled_entity_types.useEntityStoreTypes)();
  const enableStoreMutation = (0, _use_entity_store.useEnableEntityStoreMutation)();
  const stopEntityEngineMutation = (0, _use_entity_store.useStopEntityEngineMutation)(entityTypes);
  const deleteEntityEngineMutation = (0, _use_entity_store.useDeleteEntityEngineMutation)({
    onSuccess: () => {
      closeClearModal();
    },
    entityTypes
  });
  const [isClearModalVisible, setIsClearModalVisible] = (0, _react.useState)(false);
  const closeClearModal = (0, _react.useCallback)(() => setIsClearModalVisible(false), []);
  const showClearModal = (0, _react.useCallback)(() => setIsClearModalVisible(true), []);
  const onSwitchClick = (0, _react.useCallback)(() => {
    var _entityStoreStatus$da, _entityStoreStatus$da2;
    if (isSwitchDisabled((_entityStoreStatus$da = entityStoreStatus.data) === null || _entityStoreStatus$da === void 0 ? void 0 : _entityStoreStatus$da.status)) {
      return;
    }
    if (isEntityStoreEnabled((_entityStoreStatus$da2 = entityStoreStatus.data) === null || _entityStoreStatus$da2 === void 0 ? void 0 : _entityStoreStatus$da2.status)) {
      stopEntityEngineMutation.mutate();
    } else {
      enableStoreMutation.mutate({});
    }
  }, [(_entityStoreStatus$da3 = entityStoreStatus.data) === null || _entityStoreStatus$da3 === void 0 ? void 0 : _entityStoreStatus$da3.status, stopEntityEngineMutation, enableStoreMutation]);
  const {
    data: privileges
  } = (0, _use_entity_engine_privileges.useEntityEnginePrivileges)();
  const shouldDisplayEngineStatusTab = isEntityStoreInstalled((_entityStoreStatus$da4 = entityStoreStatus.data) === null || _entityStoreStatus$da4 === void 0 ? void 0 : _entityStoreStatus$da4.status) && (privileges === null || privileges === void 0 ? void 0 : privileges.has_all_required);
  (0, _react.useEffect)(() => {
    if (selectedTabId === TabId.Status && !shouldDisplayEngineStatusTab) {
      setSelectedTabId(TabId.Import);
    }
  }, [shouldDisplayEngineStatusTab, selectedTabId]);
  if (assetCriticalityIsLoading) {
    // Wait for permission before rendering content to avoid flickering
    return null;
  }
  const isMutationLoading = enableStoreMutation.isLoading || stopEntityEngineMutation.isLoading || deleteEntityEngineMutation.isLoading;
  const callouts = (((_entityStoreStatus$da5 = entityStoreStatus.data) === null || _entityStoreStatus$da5 === void 0 ? void 0 : _entityStoreStatus$da5.engines) || []).filter(engine => engine.status === 'error').map(engine => /*#__PURE__*/_react.default.createElement(_entity_store_error_callout.EntityStoreErrorCallout, {
    engine: engine,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 22
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "entityStoreManagementPage",
    pageTitle: entityStoreLabel,
    alignItems: "center",
    rightSideItems: !isEntityStoreFeatureFlagDisabled && privileges !== null && privileges !== void 0 && privileges.has_all_required ? [/*#__PURE__*/_react.default.createElement(EnablementButton, {
      isLoading: isMutationLoading || isSwitchLoading((_entityStoreStatus$da6 = entityStoreStatus.data) === null || _entityStoreStatus$da6 === void 0 ? void 0 : _entityStoreStatus$da6.status),
      isDisabled: isSwitchDisabled((_entityStoreStatus$da7 = entityStoreStatus.data) === null || _entityStoreStatus$da7 === void 0 ? void 0 : _entityStoreStatus$da7.status),
      onSwitch: onSwitchClick,
      status: (_entityStoreStatus$da8 = entityStoreStatus.data) === null || _entityStoreStatus$da8 === void 0 ? void 0 : _entityStoreStatus$da8.status,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 17
      }
    }), canDeleteEntityEngine((_entityStoreStatus$da9 = entityStoreStatus.data) === null || _entityStoreStatus$da9 === void 0 ? void 0 : _entityStoreStatus$da9.status) ? /*#__PURE__*/_react.default.createElement(ClearEntityDataButton, {
      deleteEntityEngineMutation,
      isClearModalVisible,
      closeClearModal,
      showClearModal,
      modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 19
      }
    }) : null] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.subTitle",
    defaultMessage: "Store data for entities observed in events.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  })), isEntityStoreFeatureFlagDisabled && /*#__PURE__*/_react.default.createElement(EntityStoreFeatureFlagNotAvailableCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 44
    }
  }), !privileges || privileges.has_all_required ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_entity_store_missing_privileges_callout.EntityStoreMissingPrivilegesCallout, {
    privileges: privileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "tabs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: TabId.Import,
    isSelected: selectedTabId === TabId.Import,
    onClick: () => setSelectedTabId(TabId.Import),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.importEntities.tabTitle",
    defaultMessage: "Import Entities",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  })), shouldDisplayEngineStatusTab && /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: TabId.Status,
    isSelected: selectedTabId === TabId.Status,
    onClick: () => setSelectedTabId(TabId.Status),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.engineStatus.tabTitle",
    defaultMessage: "Engine Status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }, selectedTabId === TabId.Import && /*#__PURE__*/_react.default.createElement(FileUploadSection, {
    assetCriticalityPrivilegesError: assetCriticalityPrivilegesError,
    hasEntityAnalyticsCapability: hasEntityAnalyticsCapability,
    hasAssetCriticalityWritePermissions: hasAssetCriticalityWritePermissions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }), selectedTabId === TabId.Status && /*#__PURE__*/_react.default.createElement(_engines_status.EngineStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 44
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, enableStoreMutation.isError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.errors.initErrorTitle",
      defaultMessage: 'There was a problem initializing the entity store',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 19
      }
    }),
    color: "danger",
    iconType: "alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 17
    }
  }, enableStoreMutation.error.body.message)), deleteEntityEngineMutation.isError && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.errors.deleteErrorTitle",
      defaultMessage: 'There was a problem deleting the entity store',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 19
      }
    }),
    color: "danger",
    iconType: "alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  }, deleteEntityEngineMutation.error.body.message)), selectedTabId === TabId.Import && callouts, selectedTabId === TabId.Import && /*#__PURE__*/_react.default.createElement(WhatIsAssetCriticalityPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 48
    }
  })))));
};
exports.EntityStoreManagementPage = EntityStoreManagementPage;
EntityStoreManagementPage.displayName = 'EntityStoreManagementPage';
const WhatIsAssetCriticalityPanel = () => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.intro",
    defaultMessage: "As part of importing entities using a text file, you are also able to set Asset Criticality for the imported Entities.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "question",
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.title",
    defaultMessage: "What is asset criticality?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.description",
    defaultMessage: "Asset criticality allows you to classify entities based on their importance and impact on business operations. Use asset criticality to guide prioritization for alert triaging, threat-hunting, and investigation activities.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.information.usefulLinks",
    defaultMessage: "Useful links",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: entityAnalyticsLinks.assetCriticality,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.documentationLink",
    defaultMessage: "Asset criticality documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 9
    }
  })));
};
const EntityStoreFeatureFlagNotAvailableCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.featureFlagDisabled",
      defaultMessage: "Entity Store capabilities not available",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 11
      }
    }),
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.entityStoreManagementPage.featureFlagDisabledDescription",
    defaultMessage: "The full capabilities of the Entity Store have been disabled in this environment. Contact your administrator for further assistance.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }))));
};
const EntityStoreHealth = ({
  currentEntityStoreStatus
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    textSize: "m",
    color: isEntityStoreEnabled(currentEntityStoreStatus) ? 'success' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 5
    }
  }, isEntityStoreEnabled(currentEntityStoreStatus) ? 'On' : 'Off');
};
const EnablementButton = ({
  isLoading,
  isDisabled,
  status,
  onSwitch
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 5
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "entity-store-status-loading",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(EntityStoreHealth, {
    currentEntityStoreStatus: status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: entityStoreLabel,
    onChange: onSwitch,
    "data-test-subj": "entity-store-switch",
    checked: isEntityStoreEnabled(status),
    disabled: isDisabled,
    showLabel: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 7
    }
  }));
};
const InsufficientAssetCriticalityPrivilegesCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.noPermissionTitle",
      defaultMessage: "Insufficient index privileges to perform CSV upload",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 9
      }
    }),
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.missingPermissionsCallout.description",
    defaultMessage: "Write permission is required for the {index} index pattern in order to access this functionality. Contact your administrator for further assistance.",
    values: {
      index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 402,
          columnNumber: 20
        }
      }, _asset_criticality.ASSET_CRITICALITY_INDEX_PATTERN)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 9
    }
  })));
};
const AssetCriticalityIssueCallout = ({
  errorMessage
}) => {
  const msg = errorMessage !== null && errorMessage !== void 0 ? errorMessage : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.advancedSettingDisabledMessage",
    defaultMessage: "Privileges to access the Asset Criticality feature are missing for your user. Contact your administrator for further assistance.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 414,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.unavailable",
      defaultMessage: "Asset criticality CSV file upload functionality unavailable.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 11
      }
    }),
    color: "primary",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 432,
      columnNumber: 9
    }
  }, msg)));
};
const ClearEntityDataButton = ({
  deleteEntityEngineMutation,
  isClearModalVisible,
  closeClearModal,
  showClearModal,
  modalTitleId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconType: "trash",
    onClick: () => {
      showClearModal();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.clear",
    defaultMessage: "Clear Entity Data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 9
    }
  })), isClearModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    isLoading: deleteEntityEngineMutation.isLoading,
    "aria-labelledby": modalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.clearEntitiesModal.title",
      defaultMessage: "Clear Entity data?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 471,
        columnNumber: 13
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeClearModal,
    onConfirm: () => {
      deleteEntityEngineMutation.mutate();
    },
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.clearEntitiesModal.close",
      defaultMessage: "Close",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 13
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.clearEntitiesModal.clearAllEntities",
      defaultMessage: "Clear All Entities",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 488,
        columnNumber: 13
      }
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 467,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.entityStoreManagementPage.clearConfirmation",
    defaultMessage: 'This will delete all Security Entity store records. Source data, Entity risk scores, and Asset criticality assignments are unaffected by this action. This operation cannot be undone.',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 11
    }
  })));
};
const FileUploadSection = ({
  assetCriticalityPrivilegesError,
  hasEntityAnalyticsCapability,
  hasAssetCriticalityWritePermissions
}) => {
  if (!hasEntityAnalyticsCapability || (assetCriticalityPrivilegesError === null || assetCriticalityPrivilegesError === void 0 ? void 0 : assetCriticalityPrivilegesError.body.status_code) === 403) {
    return /*#__PURE__*/_react.default.createElement(AssetCriticalityIssueCallout, {
      errorMessage: assetCriticalityPrivilegesError === null || assetCriticalityPrivilegesError === void 0 ? void 0 : assetCriticalityPrivilegesError.body.message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 519,
        columnNumber: 7
      }
    });
  }
  if (!hasAssetCriticalityWritePermissions) {
    return /*#__PURE__*/_react.default.createElement(InsufficientAssetCriticalityPrivilegesCallout, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 523,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 526,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 527,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.assetCriticalityUploadPage.description",
    defaultMessage: "Bulk assign asset criticality by importing a CSV, TXT, or TSV file exported from your asset management tools. This ensures data accuracy and reduces manual input errors.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 529,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 534,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_criticality_file_uploader.AssetCriticalityFileUploader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 7
    }
  }));
};