"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityAnalyticsLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _types = require("../../app/types");
var _header_page = require("../../common/components/header_page");
var _nav_links = require("../../common/links/nav_links");
var _page_wrapper = require("../../common/components/page_wrapper");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _trackers = require("../../common/lib/telemetry/trackers");
var _global_query_string = require("../../common/utils/global_query_string");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/pages/entity_analytics_landing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.landing.pageTitle', {
  defaultMessage: 'Entity analytics'
});
const EntityAnalyticsLandingPage = () => {
  const entityAnalyticsLandingNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.entityAnalyticsLanding);
  const entityAnalyticsLandinglinks = entityAnalyticsLandingNavLink && 'links' in entityAnalyticsLandingNavLink && Array.isArray(entityAnalyticsLandingNavLink.links) ? entityAnalyticsLandingNavLink.links : [];
  const entityAnalyticsOverviewNavLink = (0, _nav_links.useRootNavLink)(_types.SecurityPageName.entityAnalyticsOverview);
  const entityAnalyticsOverviewlinks = entityAnalyticsOverviewNavLink && 'links' in entityAnalyticsOverviewNavLink && Array.isArray(entityAnalyticsOverviewNavLink.links) ? entityAnalyticsOverviewNavLink.links : [];
  const urlState = (0, _global_query_string.useGlobalQueryString)();
  return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksImages, {
    items: entityAnalyticsLandinglinks,
    urlState: urlState,
    onLinkClick: _trackers.trackLandingLinkClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalyticsLanding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksImages, {
    items: entityAnalyticsOverviewlinks,
    urlState: urlState,
    onLinkClick: _trackers.trackLandingLinkClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.entityAnalyticsOverview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
};
exports.EntityAnalyticsLandingPage = EntityAnalyticsLandingPage;