"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskEngineSettingsMutations = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_configure_risk_engine_saved_object = require("../../../api/hooks/use_configure_risk_engine_saved_object");
var i18n = _interopRequireWildcard(require("../../../translations"));
var _use_risk_engine_settings_query = require("./use_risk_engine_settings_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskEngineSettingsMutations = (savedRiskEngineSettings, waitingForSaveRefetch, preSaveFilterCount) => {
  const {
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    mutateAsync: mutateRiskEngineSettingsAsync
  } = (0, _use_configure_risk_engine_saved_object.useConfigureSORiskEngineMutation)();
  const invalidateRiskEngineSettingsQuery = (0, _use_risk_engine_settings_query.useInvalidateRiskEngineSettingsQuery)();
  const saveSelectedSettingsMutation = (0, _reactQuery.useMutation)(async selectedRiskEngineSettings => {
    var _selectedRiskEngineSe, _selectedRiskEngineSe2;
    await mutateRiskEngineSettingsAsync({
      includeClosedAlerts: (_selectedRiskEngineSe = selectedRiskEngineSettings.includeClosedAlerts) !== null && _selectedRiskEngineSe !== void 0 ? _selectedRiskEngineSe : false,
      range: selectedRiskEngineSettings.range,
      enableResetToZero: (_selectedRiskEngineSe2 = selectedRiskEngineSettings.enableResetToZero) !== null && _selectedRiskEngineSe2 !== void 0 ? _selectedRiskEngineSe2 : true,
      filters: selectedRiskEngineSettings.filters
    }, {
      onSuccess: () => {
        addSuccess(i18n.RISK_ENGINE_SAVED_OBJECT_CONFIGURATION_SUCCESS, {
          toastLifeTimeMs: 5000
        });
      }
    });

    // Track pre-save state to detect when refetch completes
    if (preSaveFilterCount) {
      var _savedRiskEngineSetti;
      preSaveFilterCount.current = (savedRiskEngineSettings === null || savedRiskEngineSettings === void 0 ? void 0 : (_savedRiskEngineSetti = savedRiskEngineSettings.filters) === null || _savedRiskEngineSetti === void 0 ? void 0 : _savedRiskEngineSetti.length) || 0;
    }
    if (waitingForSaveRefetch) {
      waitingForSaveRefetch.current = true;
    }

    // Trigger refetch
    await invalidateRiskEngineSettingsQuery();
  });
  return {
    saveSelectedSettingsMutation
  };
};
exports.useRiskEngineSettingsMutations = useRiskEngineSettingsMutations;