"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKNOWN_RISK_DESCRIPTION = exports.TITLE = exports.INFO_BUTTON_TEXT = exports.INFORMATION_WEIGHT_HEADER = exports.INFORMATION_TIER_HEADER = exports.INFORMATION_RISK_HEADER = exports.INFORMATION_LEVEL_HEADER = exports.CRITICAL_RISK_DESCRIPTION = exports.CLOSE_BUTTON_TEXT = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../risk_score/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INFORMATION_LEVEL_HEADER = exports.INFORMATION_LEVEL_HEADER = _i18n.i18n.translate('xpack.securitySolution.riskInformation.levelHeader', {
  defaultMessage: 'Risk Level'
});
const INFORMATION_RISK_HEADER = exports.INFORMATION_RISK_HEADER = _i18n.i18n.translate('xpack.securitySolution.riskInformation.riskHeader', {
  defaultMessage: '{riskEntity} risk score range',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)()
  }
});
const INFORMATION_TIER_HEADER = exports.INFORMATION_TIER_HEADER = _i18n.i18n.translate('xpack.securitySolution.riskInformation.tierColumnHeader', {
  defaultMessage: 'Asset Criticality Tier'
});
const INFORMATION_WEIGHT_HEADER = exports.INFORMATION_WEIGHT_HEADER = _i18n.i18n.translate('xpack.securitySolution.riskInformation.weightColumnHeader', {
  defaultMessage: 'Default risk weight'
});
const UNKNOWN_RISK_DESCRIPTION = exports.UNKNOWN_RISK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskInformation.unknownRiskDescription', {
  defaultMessage: 'Less than 20'
});
const CRITICAL_RISK_DESCRIPTION = exports.CRITICAL_RISK_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.riskInformation.criticalRiskDescription', {
  defaultMessage: '90 and above'
});
const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.securitySolution.riskInformation.title', {
  defaultMessage: 'Entity Risk Analytics'
});
const CLOSE_BUTTON_TEXT = exports.CLOSE_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.riskInformation.closeBtn', {
  defaultMessage: 'Close'
});
const INFO_BUTTON_TEXT = exports.INFO_BUTTON_TEXT = _i18n.i18n.translate('xpack.securitySolution.riskInformation.buttonLabel', {
  defaultMessage: 'How is risk score calculated?'
});