"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskLevelsPrivilegedUsersPanel = exports.DONUT_CHART_HEIGHT = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _search_strategy = require("../../../../../../common/search_strategy");
var _chart_label = require("../../../../../overview/components/detection_response/alerts_by_status/chart_label");
var _donutchart = require("../../../../../common/components/charts/donutchart");
var _header_section = require("../../../../../common/components/header_section");
var _inspect = require("../../../../../common/components/inspect");
var _common = require("../../../../common");
var _use_risk_score_fill_color = require("../../../risk_score_donut_chart/use_risk_score_fill_color");
var _risk_level_esql_query = require("../../queries/risk_level_esql_query");
var _hooks = require("./hooks");
var _enable_risk_score = require("../../../enable_risk_score");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/risk_level_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.title', {
  defaultMessage: 'Privileged user risk levels'
});
const DONUT_CHART_HEIGHT = exports.DONUT_CHART_HEIGHT = 160;
const RiskLevelsPrivilegedUsersPanel = ({
  spaceId
}) => {
  const fillColor = (0, _use_risk_score_fill_color.useRiskScoreFillColor)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_risk_level_esql_query.RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const columns = (0, _hooks.useRiskLevelsTableColumns)();
  const {
    records,
    isLoading,
    refetch,
    inspect,
    isError,
    hasEngineBeenInstalled
  } = (0, _hooks.useRiskLevelsPrivilegedUserQuery)({
    skip: !toggleStatus,
    spaceId
  });
  const total = (0, _fp.sum)(records.map(({
    count
  }) => count));
  const severityTableData = (0, _react.useMemo)(() => _common.SEVERITY_UI_SORT_ORDER.map(level => {
    var _records$find$count, _records$find;
    const count = (_records$find$count = (_records$find = records.find(item => item.level === level)) === null || _records$find === void 0 ? void 0 : _records$find.count) !== null && _records$find$count !== void 0 ? _records$find$count : 0;
    return {
      level,
      count,
      percentage: total > 0 ? count / total * 100 : 0,
      total
    };
  }).reverse(), [records, total]);
  const donutChartData = (0, _react.useMemo)(() => severityTableData.map(({
    level,
    count
  }) => ({
    key: level,
    value: count
  })), [severityTableData]);
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    refetch,
    setQuery,
    queryId: _risk_level_esql_query.RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID,
    loading: isLoading
  });
  const isDisabled = !hasEngineBeenInstalled && !isLoading;
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, {
      isDisabled: isDisabled,
      entityType: _search_strategy.EntityType.user,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "severity-level-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    hideSubtitle: true,
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    id: _risk_level_esql_query.RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID,
    inspectTitle: TITLE,
    title: TITLE,
    titleSize: "m",
    outerDirection: 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), toggleStatus && (isError ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.errorLoadingData', {
      defaultMessage: 'Error loading data'
    }),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    responsiveBreakpoint: false,
    "data-test-subj": "severity-level-table",
    columns: columns,
    items: severityTableData,
    loading: isLoading,
    id: _risk_level_esql_query.RISK_LEVELS_PRIVILEGED_USERS_QUERY_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_donutchart.DonutChart, {
    data: donutChartData !== null && donutChartData !== void 0 ? donutChartData : null,
    fillColor: fillColor,
    height: DONUT_CHART_HEIGHT,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.riskLevels.totalLabel",
      defaultMessage: "privileged users",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 21
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_chart_label.ChartLabel, {
      count: total,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 26
      }
    }),
    totalCount: total,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }))))));
};
exports.RiskLevelsPrivilegedUsersPanel = RiskLevelsPrivilegedUsersPanel;