"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePadMlJobs = void 0;
var _use_security_jobs = require("../../../../../../../common/components/ml_popover/hooks/use_security_jobs");
var _helpers = require("../../../../../../../common/components/ml_popover/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePadMlJobs = searchValue => {
  const {
    isMlAdmin,
    loading: isLoadingSecurityJobs,
    jobs,
    refetch: refreshJobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const allPrivilegedAccessDetectionJobs = jobs.filter(job => job.groups.includes('pad'));
  const filteredPrivilegedAccessDetectionJobs = (0, _helpers.searchFilter)(allPrivilegedAccessDetectionJobs, searchValue);
  return {
    jobs: filteredPrivilegedAccessDetectionJobs,
    refreshJobs,
    isMlAdmin,
    isLoadingSecurityJobs
  };
};
exports.usePadMlJobs = usePadMlJobs;