"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUsersTile = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _Either = require("fp-ts/Either");
var _esql_query = require("./esql_query");
var _key_insights_tile = require("../common/key_insights_tile");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/key_insights_panel/privileged_users_tile/privileged_users_tile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PrivilegedUsersTile = ({
  spaceId
}) => {
  return /*#__PURE__*/_react.default.createElement(_key_insights_tile.KeyInsightsTile, {
    title: _i18n.i18n.translate('xpack.securitySolution.privmon.activePrivilegedUsers.title', {
      defaultMessage: 'Privileged users'
    }),
    label: _i18n.i18n.translate('xpack.securitySolution.privmon.activePrivilegedUsers.label', {
      defaultMessage: 'Privileged users'
    }),
    getEsqlQuery: namespace => (0, _Either.right)((0, _esql_query.getPrivilegedUsersEsqlCount)(namespace)),
    id: "privileged-user-monitoring-active-users",
    spaceId: spaceId,
    inspectTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.privmon.privilegedUsers.inspectTitle",
      defaultMessage: "Privileged users",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
};
exports.PrivilegedUsersTile = PrivilegedUsersTile;