"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsLink = exports.alertSummaryLink = exports.alertDetectionsLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _alerts = require("../common/icons/alerts");
var _attacks = require("../common/icons/attacks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsLink = exports.alertsLink = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.detections`]],
  globalNavPosition: 3,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.alerts', {
    defaultMessage: 'Alerts'
  })],
  id: _constants.SecurityPageName.alerts,
  path: _constants.ALERTS_PATH,
  title: _translations.ALERTS
};
const alertsSubLink = {
  ...alertsLink,
  globalNavPosition: undefined,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.alerts.description', {
    defaultMessage: 'Review individual detections triggered by security rules and take immediate action.'
  }),
  landingIcon: _alerts.IconAlerts
};
const attacksSubLink = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.ATTACK_DISCOVERY_FEATURE_ID}.attack-discovery`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.attacks', {
    defaultMessage: 'Attacks'
  })],
  id: _constants.SecurityPageName.attacks,
  path: _constants.ATTACKS_PATH,
  title: _translations.ATTACKS,
  description: _i18n.i18n.translate('xpack.securitySolution.appLinks.attacks.description', {
    defaultMessage: 'View correlated alerts grouped into attack chains to understand scope, impact, and progression.'
  }),
  landingIcon: _attacks.IconAttacks
};
const alertDetectionsLinks = exports.alertDetectionsLinks = {
  id: _constants.SecurityPageName.alertDetections,
  title: _i18n.i18n.translate('xpack.securitySolution.appLinks.alertDetections.title', {
    defaultMessage: 'Detections'
  }),
  path: _constants.ALERT_DETECTIONS,
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.detections`], [`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.ATTACK_DISCOVERY_FEATURE_ID}.attack-discovery`]],
  globalNavPosition: 3,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.alertDetections', {
    defaultMessage: 'Detections'
  })],
  links: [attacksSubLink, alertsSubLink],
  skipUrlState: true,
  categories: [{
    label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.views', {
      defaultMessage: 'Views'
    }),
    linkIds: [_constants.SecurityPageName.attacks, _constants.SecurityPageName.alerts]
  }]
};
const alertSummaryLink = exports.alertSummaryLink = {
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.SECURITY_FEATURE_ID}.external_detections`]],
  globalNavPosition: 3,
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.alertSummary', {
    defaultMessage: 'Alert summary'
  })],
  hideTimeline: true,
  id: _constants.SecurityPageName.alertSummary,
  path: _constants.ALERT_SUMMARY_PATH,
  title: _translations.ALERT_SUMMARY
};