"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToIntegrationsPage = exports.INTEGRATIONS_URL = void 0;
var _react = require("react");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATIONS_URL = exports.INTEGRATIONS_URL = '/app/security/configurations/integrations/browse';

/**
 * Hook that returns a callback event to navigate to the EASE integrations page
 */
const useNavigateToIntegrationsPage = () => {
  const {
    services: {
      http: {
        basePath: {
          prepend
        }
      }
    }
  } = (0, _kibana.useKibana)();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  return (0, _react.useCallback)(() => {
    navigateTo({
      url: prepend(INTEGRATIONS_URL)
    });
  }, [navigateTo, prepend]);
};
exports.useNavigateToIntegrationsPage = useNavigateToIntegrationsPage;