"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigFieldsComponent = exports.ConfigFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _overwrite_process_field = require("./overwrite_process_field");
var _field_name = require("./field_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/endpoint/config_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfigFieldsComponent = ({
  basePath,
  disabled,
  readDefaultValueOnForm
}) => {
  const commandPath = `${basePath}.command`;
  const overWritePath = `${basePath}.config.overwrite`;
  const [data] = (0, _hook_form_lib.useFormData)({
    watch: [commandPath, overWritePath]
  });
  const currentCommand = (0, _lodash.get)(data, commandPath);
  const currentOverwrite = (0, _lodash.get)(data, overWritePath);
  if (currentCommand === 'kill-process' || currentCommand === 'suspend-process') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_overwrite_process_field.OverwriteField, {
      path: `${basePath}.config.overwrite`,
      disabled: disabled,
      readDefaultValueOnForm: readDefaultValueOnForm,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_field_name.FieldNameField, {
      path: `${basePath}.config.field`,
      disabled: disabled,
      readDefaultValueOnForm: readDefaultValueOnForm,
      isRequired: !currentOverwrite,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }));
  }
  return null;
};
exports.ConfigFieldsComponent = ConfigFieldsComponent;
const ConfigFields = exports.ConfigFields = /*#__PURE__*/_react.default.memo(ConfigFieldsComponent);