"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShowingRulesParams = exports.RulesTableUtilityBar = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _utility_bar = require("../../../../common/components/utility_bar");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _kibana = require("../../../../common/lib/kibana");
var _rules_table_context = require("../rules_table/rules_table/rules_table_context");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _auto_refresh_button = require("../auto_refresh_button/auto_refresh_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table_utility_bar/rules_table_utility_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getShowingRulesParams = ({
  page,
  perPage,
  total: totalRules
}) => {
  const firstInPage = totalRules === 0 ? 0 : (page - 1) * perPage + 1;
  const lastInPage = page * perPage > totalRules ? totalRules : page * perPage;
  return [firstInPage, lastInPage, totalRules];
};
exports.getShowingRulesParams = getShowingRulesParams;
const RulesTableUtilityBar = exports.RulesTableUtilityBar = /*#__PURE__*/_react.default.memo(({
  canBulkEdit,
  onGetBulkItemsPopoverContent,
  onToggleSelectAll,
  isBulkActionInProgress
}) => {
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContext)();
  const {
    pagination,
    selectedRuleIds,
    isRefreshOn,
    isAllSelected,
    loadingRulesAction
  } = rulesTableContext.state;
  const {
    reFetchRules,
    setIsRefreshOn
  } = rulesTableContext.actions;
  const selectedRulesCount = isAllSelected ? pagination.total : selectedRuleIds.length;
  const isAnyRuleSelected = selectedRulesCount > 0;
  const hasDisabledActions = loadingRulesAction != null;
  const handleRefreshRules = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.REFRESH
    });
    reFetchRules();
  }, [reFetchRules, startTransaction]);
  const handleGetBulkItemsPopoverContent = (0, _react.useCallback)(closePopover => {
    if (onGetBulkItemsPopoverContent != null) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
        initialPanelId: 0,
        panels: onGetBulkItemsPopoverContent(closePopover),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      });
    } else {
      return null;
    }
  }, [onGetBulkItemsPopoverContent]);
  return /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBar, {
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "showingRules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, i18n.SHOWING_RULES(...getShowingRulesParams(pagination)))), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarGroup, {
    "data-test-subj": "tableBulkActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarText, {
    dataTestSubj: "selectedRules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, i18n.SELECTED_RULES(selectedRulesCount)), canBulkEdit && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    disabled: hasDisabledActions,
    dataTestSubj: "selectAllRules",
    iconType: isAllSelected ? 'cross' : 'pagesSelect',
    iconSide: "left",
    onClick: onToggleSelectAll,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }, isAllSelected ? i18n.CLEAR_SELECTION : i18n.SELECT_ALL_RULES(pagination.total)), canBulkEdit && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    disabled: hasDisabledActions,
    inProgress: isBulkActionInProgress,
    dataTestSubj: "bulkActions",
    iconSide: "right",
    iconType: "arrowDown",
    popoverPanelPaddingSize: "none",
    popoverContent: handleGetBulkItemsPopoverContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 17
    }
  }, i18n.BATCH_ACTIONS), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    disabled: hasDisabledActions,
    dataTestSubj: "refreshRulesAction",
    iconSide: "left",
    iconType: "refresh",
    onClick: handleRefreshRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, i18n.REFRESH), !rulesTableContext.state.isDefault && /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarAction, {
    dataTestSubj: "clearTableFilters",
    iconSide: "left",
    iconType: "cross",
    onClick: rulesTableContext.actions.clearFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }, i18n.CLEAR_RULES_TABLE_FILTERS)))), /*#__PURE__*/_react.default.createElement(_utility_bar.UtilityBarSection, {
    dataTestSubj: "refreshRulesStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, timelines.getLastUpdated({
    showUpdating: rulesTableContext.state.isFetching,
    updatedAt: rulesTableContext.state.lastUpdated
  }), /*#__PURE__*/_react.default.createElement(_auto_refresh_button.AutoRefreshButton, {
    isDisabled: hasDisabledActions || isAnyRuleSelected,
    isRefreshOn: isRefreshOn,
    reFetchRules: reFetchRules,
    setIsRefreshOn: setIsRefreshOn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })));
});
RulesTableUtilityBar.displayName = 'RulesTableUtilityBar';