"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleFeatureTour = exports.CREATE_NEW_RULE_TOUR_ANCHOR = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _use_is_element_mounted = require("../rules_table/guided_onboarding/use_is_element_mounted");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/feature_tour/rules_feature_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CREATE_NEW_RULE_TOUR_ANCHOR = exports.CREATE_NEW_RULE_TOUR_ANCHOR = 'create-new-rule-tour-anchor';
const TOUR_STORAGE_KEY = _constants.NEW_FEATURES_TOUR_STORAGE_KEYS.RULE_MANAGEMENT_PAGE;
const TOUR_POPOVER_WIDTH = 400;
const tourConfig = {
  currentTourStep: 1,
  isTourActive: true,
  tourPopoverWidth: TOUR_POPOVER_WIDTH,
  tourSubtitle: ''
};
const stepsConfig = [{
  step: 1,
  title: i18n.IM_DOES_NOT_MATCH_TOUR_TITLE,
  content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 14
    }
  }, i18n.IM_DOES_NOT_MATCH_TOUR_DESCRIPTION),
  stepsTotal: 1,
  children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
  onFinish: _lodash.noop,
  maxWidth: TOUR_POPOVER_WIDTH
}];
const RuleFeatureTour = () => {
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const restoredState = (0, _react.useMemo)(() => ({
    ...tourConfig,
    ...storage.get(TOUR_STORAGE_KEY)
  }), [storage]);
  const [tourSteps, tourActions, tourState] = (0, _eui.useEuiTour)(stepsConfig, restoredState);
  (0, _react.useEffect)(() => {
    const {
      isTourActive,
      currentTourStep
    } = tourState;
    storage.set(TOUR_STORAGE_KEY, {
      isTourActive,
      currentTourStep
    });
  }, [tourState, storage]);
  const isTourAnchorMounted = (0, _use_is_element_mounted.useIsElementMounted)(CREATE_NEW_RULE_TOUR_ANCHOR);
  const shouldShowRuleUpgradeTour = isTourAnchorMounted;
  const enhancedSteps = (0, _react.useMemo)(() => tourSteps.map((item, index) => ({
    ...item,
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, item.content, tourSteps.length > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "arrowLeft",
      "aria-label": i18n.PREVIOUS_STEP_LABEL,
      display: "empty",
      disabled: index === 0,
      onClick: tourActions.decrementStep,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "arrowRight",
      "aria-label": i18n.NEXT_STEP_LABEL,
      display: "base",
      disabled: index === tourSteps.length - 1,
      onClick: tourActions.incrementStep,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 21
      }
    })))))
  })), [tourSteps, tourActions]);
  return shouldShowRuleUpgradeTour ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, enhancedSteps[0], {
    /**
     * children={undefined} is needed to narrow down EuiTourStepProps. Without
     * it we get a TS error: Types of property 'anchor' are incompatible.
     */
    // eslint-disable-next-line react/no-children-prop
    children: undefined,
    anchor: `#${CREATE_NEW_RULE_TOUR_ANCHOR}`,
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  })) : null;
};
exports.RuleFeatureTour = RuleFeatureTour;