"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddElasticRulesButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../../../../common/components/links");
var _common = require("../../../../../common");
var _use_prebuilt_rules_status = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/pre_packaged_rules/add_elastic_rules_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddElasticRulesButton = ({
  'data-test-subj': dataTestSubj = 'addElasticRulesButton',
  fill,
  isDisabled,
  showBadge = true
}) => {
  var _preBuiltRulesStatus$;
  const getSecuritySolutionLinkProps = (0, _links.useGetSecuritySolutionLinkProps)();
  const {
    onClick: onClickLink
  } = getSecuritySolutionLinkProps({
    deepLinkId: _common.SecurityPageName.rulesAdd
  });
  const {
    data: preBuiltRulesStatus
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const newRulesCount = (_preBuiltRulesStatus$ = preBuiltRulesStatus === null || preBuiltRulesStatus === void 0 ? void 0 : preBuiltRulesStatus.stats.num_prebuilt_rules_to_install) !== null && _preBuiltRulesStatus$ !== void 0 ? _preBuiltRulesStatus$ : 0;
  const ButtonComponent = fill ? _eui.EuiButton : _eui.EuiButtonEmpty;
  return /*#__PURE__*/_react.default.createElement(ButtonComponent, {
    fill: fill,
    iconType: "plusInCircle",
    color: 'primary',
    onClick: onClickLink,
    "data-test-subj": dataTestSubj,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, i18n.ADD_ELASTIC_RULES, newRulesCount > 0 && showBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: '#E0E5EE',
    css: (0, _react2.css)`
            margin-left: 5px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, newRulesCount));
};
exports.AddElasticRulesButton = AddElasticRulesButton;