"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PREBUILT_RULE_UPDATE_FLYOUT_ANCHOR = void 0;
exports.usePrebuiltRulesUpgrade = usePrebuiltRulesUpgrade;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../common/lib/telemetry/events/rule_upgrade/types");
var _prebuilt_rule_upgrade = require("../model/prebuilt_rule_upgrade");
var _per_field_rule_diff_tab = require("../components/rule_details/per_field_rule_diff_tab");
var _use_upgrade_security_packages = require("../logic/use_upgrade_security_packages");
var _use_prebuilt_rules_customization_status = require("../logic/prebuilt_rules/use_prebuilt_rules_customization_status");
var _use_perform_rule_upgrade = require("../logic/prebuilt_rules/use_perform_rule_upgrade");
var _use_prebuilt_rules_upgrade_review = require("../logic/prebuilt_rules/use_prebuilt_rules_upgrade_review");
var _detection_engine = require("../../../../common/api/detection_engine");
var _use_prebuilt_rules_upgrade_state = require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_prebuilt_rules_upgrade_state");
var _use_ml_jobs_upgrade_modal = require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_ml_jobs_upgrade_modal");
var _use_upgrade_with_conflicts_modal = require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_upgrade_with_conflicts_modal");
var ruleDetailsI18n = _interopRequireWildcard(require("../components/rule_details/translations"));
var i18n = _interopRequireWildcard(require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/translations"));
var _upgrade_flyout_subheader = require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/upgrade_flyout_subheader");
var _customization_disabled_callout = require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/customization_disabled_callout");
var _three_way_diff = require("../components/rule_details/three_way_diff");
var _rule_type_change_callout = require("../../rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/rule_type_change_callout");
var _rule_diff_tab = require("../components/rule_details/rule_diff_tab");
var _use_rule_preview_flyout = require("../../rule_management_ui/components/rules_table/use_rule_preview_flyout");
var _constants = require("../../rule_management_ui/components/rules_table/constants");
var _kibana = require("../../../common/lib/kibana");
var _rule_details_flyout = require("../components/rule_details/rule_details_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/hooks/use_prebuilt_rules_upgrade.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REVIEW_PREBUILT_RULES_UPGRADE_REFRESH_INTERVAL = 5 * 60 * 1000;
const RULE_UPGRADE_FLYOUT_BUTTON_EVENT_VERSION = 2;
const RULE_UPGRADE_FLYOUT_OPEN_EVENT_VERSION = 2;
const PREBUILT_RULE_UPDATE_FLYOUT_ANCHOR = exports.PREBUILT_RULE_UPDATE_FLYOUT_ANCHOR = 'updatePrebuiltRulePreview';
function usePrebuiltRulesUpgrade({
  pagination = {
    page: 1,
    perPage: _constants.RULES_TABLE_INITIAL_PAGE_SIZE
  },
  sort,
  filter,
  onUpgrade
}) {
  const {
    isRulesCustomizationEnabled
  } = (0, _use_prebuilt_rules_customization_status.usePrebuiltRulesCustomizationStatus)();
  const isUpgradingSecurityPackages = (0, _use_upgrade_security_packages.useIsUpgradingSecurityPackages)();
  const [loadingRules, setLoadingRules] = (0, _react.useState)([]);
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    data: upgradeReviewResponse,
    refetch,
    dataUpdatedAt,
    isFetched,
    isLoading,
    isFetching,
    isRefetching
  } = (0, _use_prebuilt_rules_upgrade_review.usePrebuiltRulesUpgradeReview)({
    page: pagination.page,
    per_page: pagination.perPage,
    sort,
    filter
  }, {
    refetchInterval: REVIEW_PREBUILT_RULES_UPGRADE_REFRESH_INTERVAL,
    keepPreviousData: true // Use this option so that the state doesn't jump between "success" and "loading" on page change
  });
  const upgradeableRules = (0, _react.useMemo)(() => {
    var _upgradeReviewRespons;
    return (_upgradeReviewRespons = upgradeReviewResponse === null || upgradeReviewResponse === void 0 ? void 0 : upgradeReviewResponse.rules) !== null && _upgradeReviewRespons !== void 0 ? _upgradeReviewRespons : [];
  }, [upgradeReviewResponse]);
  const {
    rulesUpgradeState,
    setRuleFieldResolvedValue
  } = (0, _use_prebuilt_rules_upgrade_state.usePrebuiltRulesUpgradeState)(upgradeableRules);
  const ruleUpgradeStates = (0, _react.useMemo)(() => Object.values(rulesUpgradeState), [rulesUpgradeState]);
  const {
    modal: confirmLegacyMlJobsUpgradeModal,
    confirmLegacyMLJobs,
    isLoading: areMlJobsLoading
  } = (0, _use_ml_jobs_upgrade_modal.useOutdatedMlJobsUpgradeModal)();
  const {
    modal: upgradeConflictsModal,
    confirmConflictsUpgrade
  } = (0, _use_upgrade_with_conflicts_modal.useUpgradeWithConflictsModal)();
  const {
    mutateAsync: upgradeRulesRequest
  } = (0, _use_perform_rule_upgrade.usePerformUpgradeRules)();
  const upgradeRulesWithDryRun = useRulesUpgradeWithDryRun(confirmConflictsUpgrade);
  const upgradeRulesToResolved = (0, _react.useCallback)(async ruleIds => {
    const ruleUpgradeSpecifiers = ruleIds.map(ruleId => ({
      rule_id: ruleId,
      version: rulesUpgradeState[ruleId].target_rule.version,
      revision: rulesUpgradeState[ruleId].revision,
      fields: constructRuleFieldsToUpgrade(rulesUpgradeState[ruleId])
    }));
    setLoadingRules(prev => [...prev, ...ruleIds]);
    try {
      // Handle MLJobs modal
      if (!(await confirmLegacyMLJobs())) {
        return;
      }
      await upgradeRulesWithDryRun({
        mode: 'SPECIFIC_RULES',
        pick_version: 'MERGED',
        rules: ruleUpgradeSpecifiers
      });
    } catch {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      const upgradedRuleIdsSet = new Set(ruleIds);
      if (onUpgrade) {
        onUpgrade();
      }
      setLoadingRules(prev => prev.filter(id => !upgradedRuleIdsSet.has(id)));
    }
  }, [rulesUpgradeState, confirmLegacyMLJobs, upgradeRulesWithDryRun, onUpgrade]);
  const upgradeRulesToTarget = (0, _react.useCallback)(async ruleIds => {
    const ruleUpgradeSpecifiers = ruleIds.map(ruleId => ({
      rule_id: ruleId,
      version: rulesUpgradeState[ruleId].target_rule.version,
      revision: rulesUpgradeState[ruleId].revision
    }));
    setLoadingRules(prev => [...prev, ...ruleIds]);
    try {
      // Handle MLJobs modal
      if (!(await confirmLegacyMLJobs())) {
        return;
      }
      await upgradeRulesRequest({
        mode: 'SPECIFIC_RULES',
        pick_version: 'TARGET',
        rules: ruleUpgradeSpecifiers
      });
    } catch {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      const upgradedRuleIdsSet = new Set(ruleIds);
      if (onUpgrade) {
        onUpgrade();
      }
      setLoadingRules(prev => prev.filter(id => !upgradedRuleIdsSet.has(id)));
    }
  }, [confirmLegacyMLJobs, onUpgrade, rulesUpgradeState, upgradeRulesRequest]);
  const upgradeRules = (0, _react.useCallback)(async ruleIds => {
    if (isRulesCustomizationEnabled) {
      await upgradeRulesToResolved(ruleIds);
    } else {
      await upgradeRulesToTarget(ruleIds);
    }
  }, [isRulesCustomizationEnabled, upgradeRulesToResolved, upgradeRulesToTarget]);
  const upgradeAllRules = (0, _react.useCallback)(async () => {
    setLoadingRules(prev => [...prev, ...upgradeableRules.map(rule => rule.rule_id)]);
    try {
      // Handle MLJobs modal
      if (!(await confirmLegacyMLJobs())) {
        return;
      }
      if (isRulesCustomizationEnabled) {
        await upgradeRulesWithDryRun({
          mode: 'ALL_RULES',
          pick_version: 'MERGED',
          filter
        });
      } else {
        // Upgrading prebuilt rules to TARGET version will erase any rule customizations.
        // It's unnecessary to run a dry run request since we don't expect skipped rules.
        await upgradeRulesRequest({
          mode: 'ALL_RULES',
          pick_version: 'TARGET',
          filter
        });
      }
    } catch {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setLoadingRules([]);
    }
  }, [upgradeableRules, upgradeRulesWithDryRun, upgradeRulesRequest, confirmLegacyMLJobs, isRulesCustomizationEnabled, filter]);
  const subHeaderFactory = (0, _react.useCallback)(rule => rulesUpgradeState[rule.rule_id] ? /*#__PURE__*/_react.default.createElement(_upgrade_flyout_subheader.UpgradeFlyoutSubHeader, {
    ruleUpgradeState: rulesUpgradeState[rule.rule_id],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }) : null, [rulesUpgradeState]);
  const ruleActionsFactory = (0, _react.useCallback)((rule, closeRulePreview, isEditingRule) => {
    var _ruleUpgradeState$dif, _ruleUpgradeState$dif2;
    const ruleUpgradeState = rulesUpgradeState[rule.rule_id];
    if (!ruleUpgradeState) {
      return null;
    }
    const hasRuleTypeChange = (_ruleUpgradeState$dif = (_ruleUpgradeState$dif2 = ruleUpgradeState.diff.fields.type) === null || _ruleUpgradeState$dif2 === void 0 ? void 0 : _ruleUpgradeState$dif2.has_update) !== null && _ruleUpgradeState$dif !== void 0 ? _ruleUpgradeState$dif : false;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: loadingRules.includes(rule.rule_id) || isRefetching || isUpgradingSecurityPackages || ruleUpgradeState.hasUnresolvedConflicts && !hasRuleTypeChange || isEditingRule,
      onClick: () => {
        if (hasRuleTypeChange || isRulesCustomizationEnabled === false) {
          // If there is a rule type change, we can't resolve conflicts, only accept the target rule
          upgradeRulesToTarget([rule.rule_id]);
        } else {
          upgradeRulesToResolved([rule.rule_id]);
        }
        closeRulePreview();
      },
      fill: true,
      "data-test-subj": "updatePrebuiltRuleFromFlyoutButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 9
      }
    }, i18n.UPDATE_BUTTON_LABEL);
  }, [rulesUpgradeState, loadingRules, isRefetching, isUpgradingSecurityPackages, isRulesCustomizationEnabled, upgradeRulesToTarget, upgradeRulesToResolved]);
  const extraTabsFactory = (0, _react.useCallback)(rule => {
    var _ruleUpgradeState$dif3, _ruleUpgradeState$dif4;
    const ruleUpgradeState = rulesUpgradeState[rule.rule_id];
    if (!ruleUpgradeState) {
      return [];
    }
    const hasRuleTypeChange = (_ruleUpgradeState$dif3 = (_ruleUpgradeState$dif4 = ruleUpgradeState.diff.fields.type) === null || _ruleUpgradeState$dif4 === void 0 ? void 0 : _ruleUpgradeState$dif4.has_update) !== null && _ruleUpgradeState$dif3 !== void 0 ? _ruleUpgradeState$dif3 : false;
    const hasCustomizations = ruleUpgradeState.current_rule.rule_source.type === 'external' && ruleUpgradeState.current_rule.rule_source.is_customized;
    let headerCallout = null;
    if (hasCustomizations && !isRulesCustomizationEnabled) {
      headerCallout = /*#__PURE__*/_react.default.createElement(_customization_disabled_callout.CustomizationDisabledCallout, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 25
        }
      });
    } else if (hasRuleTypeChange && isRulesCustomizationEnabled) {
      headerCallout = /*#__PURE__*/_react.default.createElement(_rule_type_change_callout.RuleTypeChangeCallout, {
        hasCustomizations: hasCustomizations,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 25
        }
      });
    }
    let updateTabContent = /*#__PURE__*/_react.default.createElement(_per_field_rule_diff_tab.PerFieldRuleDiffTab, {
      header: headerCallout,
      ruleDiff: ruleUpgradeState.diff,
      leftDiffSideLabel: i18n.CURRENT_RULE_VERSION,
      rightDiffSideLabel: i18n.ELASTIC_UPDATE_VERSION,
      leftDiffSideDescription: i18n.CURRENT_VERSION_DESCRIPTION,
      rightDiffSideDescription: i18n.UPDATED_VERSION_DESCRIPTION,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 9
      }
    });

    // Show the resolver tab only if rule customization is enabled and there
    // is no rule type change. In case of rule type change users can't resolve
    // conflicts, only accept the target rule.
    if (isRulesCustomizationEnabled && !hasRuleTypeChange) {
      updateTabContent = /*#__PURE__*/_react.default.createElement(_three_way_diff.RuleUpgradeTab, {
        ruleUpgradeState: ruleUpgradeState,
        setRuleFieldResolvedValue: setRuleFieldResolvedValue,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 11
        }
      });
    }
    const updatesTab = {
      id: 'updates',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: i18n.UPDATE_FLYOUT_PER_FIELD_TOOLTIP_DESCRIPTION,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 335,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleDetailsI18n.UPDATES_TAB_LABEL)),
      content: /*#__PURE__*/_react.default.createElement(_rule_details_flyout.TabContentPadding, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 339,
          columnNumber: 18
        }
      }, updateTabContent)
    };
    const jsonViewTab = {
      id: 'jsonViewUpdates',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: i18n.UPDATE_FLYOUT_JSON_VIEW_TOOLTIP_DESCRIPTION,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 345,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleDetailsI18n.JSON_VIEW_UPDATES_TAB_LABEL)),
      content: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_diff_tab.RuleDiffTab, {
        oldRule: ruleUpgradeState.current_rule,
        newRule: ruleUpgradeState.target_rule,
        leftDiffSideLabel: i18n.CURRENT_RULE_VERSION,
        rightDiffSideLabel: i18n.ELASTIC_UPDATE_VERSION,
        leftDiffSideDescription: i18n.CURRENT_VERSION_DESCRIPTION,
        rightDiffSideDescription: i18n.UPDATED_VERSION_DESCRIPTION,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 13
        }
      }))
    };
    return [updatesTab, jsonViewTab];
  }, [rulesUpgradeState, isRulesCustomizationEnabled, setRuleFieldResolvedValue]);
  const closeRulePreviewAction = (rule, reason) => {
    const ruleUpgradeState = rulesUpgradeState[rule.rule_id];
    const hasBaseVersion = ruleUpgradeState.has_base_version === true;
    if (reason === 'dismiss') {
      telemetry.reportEvent(_types.RuleUpgradeEventTypes.RuleUpgradeFlyoutButtonClick, {
        type: 'dismiss',
        hasBaseVersion,
        eventVersion: RULE_UPGRADE_FLYOUT_BUTTON_EVENT_VERSION
      });
    } else {
      telemetry.reportEvent(_types.RuleUpgradeEventTypes.RuleUpgradeFlyoutButtonClick, {
        type: 'update',
        hasBaseVersion,
        eventVersion: RULE_UPGRADE_FLYOUT_BUTTON_EVENT_VERSION
      });
    }
  };
  const {
    rulePreviewFlyout,
    openRulePreview: openRulePreviewDefault
  } = (0, _use_rule_preview_flyout.useRulePreviewFlyout)({
    rules: ruleUpgradeStates.map(({
      target_rule: targetRule
    }) => targetRule),
    subHeaderFactory,
    ruleActionsFactory,
    extraTabsFactory,
    flyoutProps: {
      id: PREBUILT_RULE_UPDATE_FLYOUT_ANCHOR,
      dataTestSubj: PREBUILT_RULE_UPDATE_FLYOUT_ANCHOR
    },
    closeRulePreviewAction
  });
  const openRulePreview = (0, _react.useCallback)(ruleId => {
    openRulePreviewDefault(ruleId);
    const ruleUpgradeState = rulesUpgradeState[ruleId];
    const hasBaseVersion = ruleUpgradeState.has_base_version === true;
    telemetry.reportEvent(_types.RuleUpgradeEventTypes.RuleUpgradeFlyoutOpen, {
      hasBaseVersion,
      eventVersion: RULE_UPGRADE_FLYOUT_OPEN_EVENT_VERSION
    });
  }, [openRulePreviewDefault, rulesUpgradeState, telemetry]);
  return {
    ruleUpgradeStates,
    upgradeReviewResponse,
    isFetched,
    isLoading: isLoading || areMlJobsLoading,
    isFetching,
    isRefetching,
    isUpgradingSecurityPackages,
    loadingRules,
    lastUpdated: dataUpdatedAt,
    rulePreviewFlyout,
    confirmLegacyMlJobsUpgradeModal,
    upgradeConflictsModal,
    openRulePreview,
    reFetchRules: refetch,
    upgradeRules,
    upgradeAllRules
  };
}

/**
 * Upgrades rules in two steps
 * - first fires a dry run request to check for rule upgrade conflicts. If there are conflicts
 *   it calls `confirmConflictsUpgrade()` and await its result.
 * - second it either fires a request to upgrade rules or exits depending on user's choice
 */
function useRulesUpgradeWithDryRun(confirmConflictsUpgrade) {
  const {
    mutateAsync: upgradeRulesRequest
  } = (0, _use_perform_rule_upgrade.usePerformUpgradeRules)();
  return (0, _react.useCallback)(async requestParams => {
    const dryRunResults = await upgradeRulesRequest({
      ...requestParams,
      dry_run: true,
      on_conflict: _detection_engine.UpgradeConflictResolutionEnum.SKIP
    });
    const numOfRulesWithSolvableConflicts = dryRunResults.results.skipped.filter(x => x.reason === _detection_engine.SkipRuleUpgradeReasonEnum.CONFLICT && x.conflict === _detection_engine.ThreeWayDiffConflict.SOLVABLE).length;
    const numOfRulesWithNonSolvableConflicts = dryRunResults.results.skipped.filter(x => x.reason === _detection_engine.SkipRuleUpgradeReasonEnum.CONFLICT && x.conflict === _detection_engine.ThreeWayDiffConflict.NON_SOLVABLE).length;
    if (numOfRulesWithSolvableConflicts === 0 && numOfRulesWithNonSolvableConflicts === 0) {
      // There are no rule with conflicts
      await upgradeRulesRequest({
        ...requestParams,
        on_conflict: _detection_engine.UpgradeConflictResolutionEnum.SKIP
      });
    } else {
      const result = await confirmConflictsUpgrade({
        numOfRulesWithoutConflicts: dryRunResults.results.updated.length,
        numOfRulesWithSolvableConflicts,
        numOfRulesWithNonSolvableConflicts
      });
      if (!result) {
        return;
      }
      await upgradeRulesRequest({
        ...requestParams,
        on_conflict: result === _use_upgrade_with_conflicts_modal.ConfirmRulesUpgrade.WithSolvableConflicts ? _detection_engine.UpgradeConflictResolutionEnum.UPGRADE_SOLVABLE : _detection_engine.UpgradeConflictResolutionEnum.SKIP
      });
    }
  }, [upgradeRulesRequest, confirmConflictsUpgrade]);
}
function constructRuleFieldsToUpgrade(ruleUpgradeState) {
  const ruleFieldsToUpgrade = {};
  for (const [fieldName, fieldUpgradeState] of Object.entries(ruleUpgradeState.fieldsUpgradeState)) {
    if (fieldUpgradeState.state === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.Accepted) {
      ruleFieldsToUpgrade[fieldName] = {
        pick_version: 'RESOLVED',
        resolved_value: fieldUpgradeState.resolvedValue
      };
    }
  }
  return ruleFieldsToUpgrade;
}