"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleNameOverrideEdit = RuleNameOverrideEdit;
exports.ruleNameOverrideDeserializer = ruleNameOverrideDeserializer;
exports.ruleNameOverrideSchema = void 0;
exports.ruleNameOverrideSerializer = ruleNameOverrideSerializer;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _schema = require("../../../../../../rule_creation_ui/components/step_about_rule/schema");
var _es_field_selector_field = require("../../../../../../rule_creation_ui/components/es_field_selector_field");
var _form = require("../../../../../../rule_creation_ui/pages/form");
var _utils = require("../utils");
var _use_default_index_pattern = require("../../../../../hooks/use_default_index_pattern");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/rule_name_override.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ruleNameOverrideSchema = exports.ruleNameOverrideSchema = {
  ruleNameOverride: _schema.schema.ruleNameOverride
};
function RuleNameOverrideEdit({
  finalDiffableRule
}) {
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const indexPatternParameters = (0, _utils.getUseRuleIndexPatternParameters)(finalDiffableRule, defaultIndexPattern);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)(indexPatternParameters);
  const componentProps = (0, _react.useMemo)(() => ({
    fieldType: 'string',
    indices: indexPattern,
    isDisabled: isIndexPatternLoading
  }), [indexPattern, isIndexPatternLoading]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "ruleNameOverride",
    component: _es_field_selector_field.EsFieldSelectorField,
    componentProps: componentProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
}
function ruleNameOverrideDeserializer(defaultValue) {
  var _defaultValue$rule_na, _defaultValue$rule_na2;
  return {
    ruleNameOverride: (_defaultValue$rule_na = (_defaultValue$rule_na2 = defaultValue.rule_name_override) === null || _defaultValue$rule_na2 === void 0 ? void 0 : _defaultValue$rule_na2.field_name) !== null && _defaultValue$rule_na !== void 0 ? _defaultValue$rule_na : ''
  };
}
function ruleNameOverrideSerializer(formData) {
  return {
    rule_name_override: formData.ruleNameOverride ? {
      field_name: formData.ruleNameOverride
    } : undefined
  };
}