"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationFieldsEdit = InvestigationFieldsEdit;
exports.investigationFieldsDeserializer = investigationFieldsDeserializer;
exports.investigationFieldsSchema = void 0;
exports.investigationFieldsSerializer = investigationFieldsSerializer;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _schema = require("../../../../../../rule_creation_ui/components/step_about_rule/schema");
var _multi_select_fields = require("../../../../../../rule_creation_ui/components/multi_select_fields");
var _hooks = require("../../../../../../rule_creation_ui/hooks");
var _use_default_index_pattern = require("../../../../../hooks/use_default_index_pattern");
var _form = require("../../../../../../rule_creation_ui/pages/form");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/investigation_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const investigationFieldsSchema = exports.investigationFieldsSchema = {
  investigationFields: _schema.schema.investigationFields
};
function InvestigationFieldsEdit({
  finalDiffableRule
}) {
  const {
    type
  } = finalDiffableRule;
  const defaultIndexPattern = (0, _use_default_index_pattern.useDefaultIndexPattern)();
  const indexPatternParameters = (0, _utils.getUseRuleIndexPatternParameters)(finalDiffableRule, defaultIndexPattern);
  const {
    indexPattern,
    isIndexPatternLoading
  } = (0, _form.useRuleIndexPattern)(indexPatternParameters);
  const {
    fields: investigationFields,
    isLoading: isInvestigationFieldsLoading
  } = (0, _hooks.useAllEsqlRuleFields)({
    esqlQuery: type === 'esql' ? finalDiffableRule.esql_query.query : undefined,
    indexPatternsFields: indexPattern.fields
  });
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "investigationFields",
    component: _multi_select_fields.MultiSelectFieldsAutocomplete,
    componentProps: {
      browserFields: investigationFields,
      isDisabled: isIndexPatternLoading || isInvestigationFieldsLoading,
      fullWidth: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
}
function investigationFieldsDeserializer(defaultValue) {
  var _defaultValue$investi, _defaultValue$investi2;
  return {
    investigationFields: (_defaultValue$investi = (_defaultValue$investi2 = defaultValue.investigation_fields) === null || _defaultValue$investi2 === void 0 ? void 0 : _defaultValue$investi2.field_names) !== null && _defaultValue$investi !== void 0 ? _defaultValue$investi : []
  };
}
function investigationFieldsSerializer(formData) {
  const hasInvestigationFields = formData.investigationFields.length > 0;
  return {
    investigation_fields: hasInvestigationFields ? {
      field_names: formData.investigationFields
    } : undefined
  };
}