"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExeptionItemsViewerEmptyPrompts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _illustration_product_no_results_magnifying_glass = _interopRequireDefault(require("../../../../common/images/illustration_product_no_results_magnifying_glass.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/all_exception_items_table/empty_viewer_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExeptionItemsViewerEmptyPromptsComponent = ({
  isReadOnly,
  isEndpoint,
  currentState,
  onCreateExceptionListItem
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const content = (0, _react.useMemo)(() => {
    switch (currentState) {
      case 'error':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          color: 'danger',
          iconType: 'error',
          title: /*#__PURE__*/_react.default.createElement("h2", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 44,
              columnNumber: 20
            }
          }, i18n.EXCEPTION_ERROR_TITLE),
          body: /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 45,
              columnNumber: 19
            }
          }, i18n.EXCEPTION_ERROR_DESCRIPTION),
          "data-test-subj": 'exceptionItemViewerEmptyPrompts-error',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 11
          }
        });
      case 'empty':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          color: 'subdued',
          iconType: 'plusInCircle',
          iconColor: euiTheme.colors.darkestShade,
          title: /*#__PURE__*/_react.default.createElement("h2", {
            "data-test-subj": "exceptionsEmptyPromptTitle",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 56,
              columnNumber: 15
            }
          }, i18n.EXCEPTION_EMPTY_PROMPT_TITLE),
          body: /*#__PURE__*/_react.default.createElement("p", {
            "data-test-subj": "exceptionsEmptyPromptBody",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 61,
              columnNumber: 15
            }
          }, isEndpoint ? i18n.EXCEPTION_EMPTY_ENDPOINT_PROMPT_BODY : i18n.EXCEPTION_EMPTY_PROMPT_BODY),
          actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": "exceptionsEmptyPromptButton",
            onClick: onCreateExceptionListItem,
            iconType: "plusInCircle",
            color: "primary",
            isDisabled: isReadOnly,
            fill: true,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 68,
              columnNumber: 15
            }
          }, isEndpoint ? i18n.EXCEPTION_EMPTY_PROMPT_ENDPOINT_BUTTON : i18n.EXCEPTION_EMPTY_PROMPT_BUTTON)],
          "data-test-subj": "exceptionItemViewerEmptyPrompts-empty",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 51,
            columnNumber: 11
          }
        });
      case 'empty_search':
        return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          color: 'plain',
          layout: 'horizontal',
          hasBorder: true,
          hasShadow: false,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
            size: "fullWidth",
            alt: "",
            url: _illustration_product_no_results_magnifying_glass.default,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 91,
              columnNumber: 19
            }
          }),
          title: /*#__PURE__*/_react.default.createElement("h3", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 92,
              columnNumber: 20
            }
          }, i18n.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_TITLE),
          body: /*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 93,
              columnNumber: 19
            }
          }, i18n.EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY),
          "data-test-subj": "exceptionItemViewerEmptyPrompts-emptySearch",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 11
          }
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
          lines: 4,
          "data-test-subj": "exceptionItemViewerEmptyPrompts-loading",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 11
          }
        });
    }
  }, [currentState, euiTheme.colors.darkestShade, isReadOnly, isEndpoint, onCreateExceptionListItem]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    color: currentState === 'empty_search' ? 'subdued' : 'transparent',
    css: {
      margin: `${euiTheme.size.l} 0`,
      padding: `${euiTheme.size.l} 0`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, content);
};
const ExeptionItemsViewerEmptyPrompts = exports.ExeptionItemsViewerEmptyPrompts = /*#__PURE__*/_react.default.memo(ExeptionItemsViewerEmptyPromptsComponent);
ExeptionItemsViewerEmptyPrompts.displayName = 'ExeptionItemsViewerEmptyPrompts';