"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSeverityOptions = exports.SeverityLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var I18n = _interopRequireWildcard(require("./translations"));
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/step_about_rule/data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiHealth = (0, _styledComponents.default)(_eui.EuiHealth)`
  line-height: inherit;
`;
let SeverityLevel = exports.SeverityLevel = /*#__PURE__*/function (SeverityLevel) {
  SeverityLevel["low"] = "low";
  SeverityLevel["medium"] = "medium";
  SeverityLevel["high"] = "high";
  SeverityLevel["critical"] = "critical";
  return SeverityLevel;
}({});
const getSeverityOptions = euiTheme => {
  const palette = (0, _risk_color_palette.getRiskSeverityColors)(euiTheme);
  return [{
    value: SeverityLevel.low,
    inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
      color: palette.low,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 21
      }
    }, I18n.LOW)
  }, {
    value: SeverityLevel.medium,
    inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
      color: palette.medium,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 21
      }
    }, I18n.MEDIUM)
  }, {
    value: SeverityLevel.high,
    inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
      color: palette.high,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 21
      }
    }, I18n.HIGH)
  }, {
    value: SeverityLevel.critical,
    inputDisplay: /*#__PURE__*/_react.default.createElement(StyledEuiHealth, {
      color: palette.critical,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 21
      }
    }, I18n.CRITICAL)
  }];
};
const useSeverityOptions = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const severityOptions = (0, _react.useMemo)(() => getSeverityOptions(euiTheme), [euiTheme]);
  return severityOptions;
};
exports.useSeverityOptions = useSeverityOptions;