"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityField = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _default_severity = require("./default_severity");
var _severity_override = require("./severity_override");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/severity_mapping/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SeverityField = ({
  dataTestSubj,
  field,
  idAria,
  indices,
  isDisabled,
  setRiskScore
}) => {
  const {
    value,
    isMappingChecked,
    mapping
  } = field.value;
  const {
    setValue
  } = field;
  const handleFieldValueChange = (0, _react.useCallback)((newMappingItems, index) => {
    setValue({
      value,
      isMappingChecked,
      mapping: [...mapping.slice(0, index), ...newMappingItems, ...mapping.slice(index + 1)]
    });
  }, [value, isMappingChecked, mapping, setValue]);
  const handleFieldChange = (0, _react.useCallback)((index, severity, [newField]) => {
    var _newField$name;
    const newMappingItems = [{
      ...mapping[index],
      field: (_newField$name = newField === null || newField === void 0 ? void 0 : newField.name) !== null && _newField$name !== void 0 ? _newField$name : '',
      value: newField != null ? mapping[index].value : '',
      operator: 'equals',
      severity
    }];
    handleFieldValueChange(newMappingItems, index);
  }, [mapping, handleFieldValueChange]);
  const handleDefaultSeverityChange = (0, _react.useCallback)(newValue => {
    setValue({
      value: newValue,
      isMappingChecked,
      mapping
    });
    setRiskScore(newValue);
  }, [isMappingChecked, mapping, setValue, setRiskScore]);
  const handleFieldMatchValueChange = (0, _react.useCallback)((index, severity, newMatchValue) => {
    const newMappingItems = [{
      ...mapping[index],
      field: mapping[index].field,
      value: mapping[index].field != null && mapping[index].field !== '' ? newMatchValue : '',
      operator: 'equals',
      severity
    }];
    handleFieldValueChange(newMappingItems, index);
  }, [mapping, handleFieldValueChange]);
  const handleSeverityMappingChecked = (0, _react.useCallback)(() => {
    setValue({
      value,
      mapping: [...mapping],
      isMappingChecked: !isMappingChecked
    });
  }, [isMappingChecked, mapping, value, setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_default_severity.DefaultSeverity, {
    value: value,
    onChange: handleDefaultSeverityChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_override.SeverityOverride, {
    isDisabled: isDisabled,
    onSeverityMappingChecked: handleSeverityMappingChecked,
    onFieldChange: handleFieldChange,
    onFieldMatchValueChange: handleFieldMatchValueChange,
    isMappingChecked: isMappingChecked,
    dataTestSubj: dataTestSubj,
    idAria: idAria,
    mapping: mapping,
    indices: indices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  })));
};
exports.SeverityField = SeverityField;