"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_DETAILS_FOR_ROW = exports.VIEW_DETAILS = exports.RULE_PREVIEW_TITLE = exports.RULE_PREVIEW_ERROR = exports.RULE_PREVIEW_DESCRIPTION = exports.REQUESTS_SAMPLE_WARNING = exports.QUERY_PREVIEW_SEE_ALL_WARNINGS = exports.QUERY_PREVIEW_SEE_ALL_ERRORS = exports.QUERY_PREVIEW_RULE_DEFINITION_INVALID_WARNING_TITLE = exports.QUERY_PREVIEW_RULE_DEFINITION_INVALID_WARNING_MESSAGE = exports.QUERY_PREVIEW_NOISE_WARNING = exports.QUERY_PREVIEW_LABEL = exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE = exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE = exports.QUERY_GRAPH_HITS_TITLE = exports.PREVIEW_TIMEOUT_WARNING = exports.PREVIEW_HISTOGRAM_DISCLAIMER = exports.ML_PREVIEW_HISTOGRAM_DISCLAIMER = exports.LOGGED_REQUEST_ITEM_ACCORDION_UNKNOWN_TIME_BUTTON = exports.LOGGED_REQUESTS_ACCORDION_BUTTON = exports.LAST_WEEK = exports.LAST_MONTH = exports.LAST_HOUR = exports.LAST_DAY = exports.ENABLED_LOGGED_REQUESTS_CHECKBOX = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LAST_HOUR = exports.LAST_HOUR = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastHour', {
  defaultMessage: 'Last hour'
});
const LAST_DAY = exports.LAST_DAY = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastDay', {
  defaultMessage: 'Last day'
});
const LAST_WEEK = exports.LAST_WEEK = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastWeek', {
  defaultMessage: 'Last week'
});
const LAST_MONTH = exports.LAST_MONTH = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.lastMonth', {
  defaultMessage: 'Last month'
});
const PREVIEW_TIMEOUT_WARNING = exports.PREVIEW_TIMEOUT_WARNING = _i18n.i18n.translate('xpack.securitySolution.stepDefineRule.previewTimeoutWarning', {
  defaultMessage: 'Preview timed out after 60 seconds'
});
const RULE_PREVIEW_ERROR = exports.RULE_PREVIEW_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.rulePreviewError', {
  defaultMessage: 'Failed to preview rule'
});
const QUERY_PREVIEW_LABEL = exports.QUERY_PREVIEW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewLabel', {
  defaultMessage: 'Select a preview timeframe'
});
const QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE = exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewInvocationCountWarningTitle', {
  defaultMessage: 'Rule preview timeframe might cause timeout'
});
const QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE = exports.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewInvocationCountWarningMessage', {
  defaultMessage: `The timeframe and rule interval that you selected for previewing this rule might cause timeout or take long time to execute. Try to decrease the timeframe and/or increase the interval if preview has timed out (this won't affect the actual rule run).`
});
const QUERY_PREVIEW_RULE_DEFINITION_INVALID_WARNING_TITLE = exports.QUERY_PREVIEW_RULE_DEFINITION_INVALID_WARNING_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewRuleDefinitionInvalidWarningTitle', {
  defaultMessage: 'Rule definition is invalid'
});
const QUERY_PREVIEW_RULE_DEFINITION_INVALID_WARNING_MESSAGE = exports.QUERY_PREVIEW_RULE_DEFINITION_INVALID_WARNING_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewRuleDefinitionInvalidWarningMessage', {
  defaultMessage: `One or more rule definition fields have validation errors that must be fixed before previewing this rule. To learn more, check the error messages for the invalid rule definition fields.`
});
const QUERY_GRAPH_HITS_TITLE = exports.QUERY_GRAPH_HITS_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewTitle', {
  defaultMessage: 'Rule Preview'
});
const QUERY_PREVIEW_NOISE_WARNING = exports.QUERY_PREVIEW_NOISE_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryGraphPreviewNoiseWarning', {
  defaultMessage: 'Noise warning: This rule may cause a lot of noise. Consider narrowing your query. This is based on a linear progression of 1 alert per hour.'
});
const PREVIEW_HISTOGRAM_DISCLAIMER = exports.PREVIEW_HISTOGRAM_DISCLAIMER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.histogramDisclaimer', {
  defaultMessage: 'Note: Alerts with multiple event.category values will be counted more than once.'
});
const ML_PREVIEW_HISTOGRAM_DISCLAIMER = exports.ML_PREVIEW_HISTOGRAM_DISCLAIMER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.mlHistogramDisclaimer', {
  defaultMessage: 'Note: Alerts with multiple host.name values will be counted more than once.'
});
const QUERY_PREVIEW_SEE_ALL_ERRORS = exports.QUERY_PREVIEW_SEE_ALL_ERRORS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewSeeAllErrors', {
  defaultMessage: 'See all errors'
});
const QUERY_PREVIEW_SEE_ALL_WARNINGS = exports.QUERY_PREVIEW_SEE_ALL_WARNINGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.queryPreviewSeeAllWarnings', {
  defaultMessage: 'See all warnings'
});
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.actions', {
  defaultMessage: 'Actions'
});
const VIEW_DETAILS = exports.VIEW_DETAILS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.viewDetailsAriaLabel', {
  defaultMessage: 'View details'
});
const ENABLED_LOGGED_REQUESTS_CHECKBOX = exports.ENABLED_LOGGED_REQUESTS_CHECKBOX = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.enabledLoggedRequestsLabel', {
  defaultMessage: 'Show Elasticsearch requests, ran during rule executions'
});
const LOGGED_REQUESTS_ACCORDION_BUTTON = exports.LOGGED_REQUESTS_ACCORDION_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.loggedRequestsAccordionButtonLabel', {
  defaultMessage: 'Preview logged requests'
});
const LOGGED_REQUEST_ITEM_ACCORDION_UNKNOWN_TIME_BUTTON = exports.LOGGED_REQUEST_ITEM_ACCORDION_UNKNOWN_TIME_BUTTON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.loggedRequestItemAccordionUnknownTimeButtonLabel', {
  defaultMessage: 'Preview logged requests'
});
const VIEW_DETAILS_FOR_ROW = ({
  ariaRowindex,
  columnValues
}) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.queryPreview.viewDetailsForRowAriaLabel', {
  values: {
    ariaRowindex,
    columnValues
  },
  defaultMessage: 'View details for the alert or event in row {ariaRowindex}, with columns {columnValues}'
});
exports.VIEW_DETAILS_FOR_ROW = VIEW_DETAILS_FOR_ROW;
const RULE_PREVIEW_TITLE = exports.RULE_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.rulePreviewTitle', {
  defaultMessage: 'Rule preview'
});
const RULE_PREVIEW_DESCRIPTION = exports.RULE_PREVIEW_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.rulePreviewDescription', {
  defaultMessage: 'Rule preview reflects the current configuration of your rule settings and exceptions, click refresh icon to see the updated preview.'
});
const REQUESTS_SAMPLE_WARNING = exports.REQUESTS_SAMPLE_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.rulePreviewRequestSampleWarningText', {
  defaultMessage: 'Sample search queries logged only for first 2 requests of each type.'
});