"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddMitreAttackThreat = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var Rulei18n = _interopRequireWildcard(require("../../../common/translations"));
var _default_value = require("../step_about_rule/default_value");
var _add_item_form = require("../add_item_form");
var i18n = _interopRequireWildcard(require("./translations"));
var _technique_fields = require("./technique_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/mitre/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require(/* webpackChunkName: "lazy_mitre_configuration" */
  '../../../../detections/mitre/mitre_tactics_techniques')));
};
const MitreAttackContainer = _styledComponents.default.div`
  margin-top: 16px;
`;
// eslint-disable-next-line react/display-name
const AddMitreAttackThreat = exports.AddMitreAttackThreat = /*#__PURE__*/(0, _react.memo)(({
  field,
  idAria,
  isDisabled
}) => {
  const removeTactic = (0, _react.useCallback)(index => {
    const values = [...field.value];
    values.splice(index, 1);
    if ((0, _fp.isEmpty)(values)) {
      field.setValue(_default_value.threatDefault);
    } else {
      field.setValue(values);
    }
  }, [field]);
  const addMitreAttackTactic = (0, _react.useCallback)(() => {
    const values = [...field.value];
    if (!(0, _fp.isEmpty)(values[values.length - 1])) {
      field.setValue([...values, {
        tactic: {
          id: 'none',
          name: 'none',
          reference: 'none'
        },
        technique: []
      }]);
    } else {
      field.setValue([{
        tactic: {
          id: 'none',
          name: 'none',
          reference: 'none'
        },
        technique: []
      }]);
    }
  }, [field]);
  const [tacticsOptions, setTacticsOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setTacticsOptions(mitreConfig.tactics);
    }
    getMitre();
  }, []);
  const updateTactic = (0, _react.useCallback)((index, value) => {
    const values = [...field.value];
    const {
      id,
      reference,
      name
    } = tacticsOptions.find(t => t.value === value) || {
      id: '',
      name: '',
      reference: ''
    };
    values.splice(index, 1, {
      ...values[index],
      tactic: {
        id,
        reference,
        name
      },
      technique: []
    });
    field.setValue([...values]);
  }, [field, tacticsOptions]);
  const values = (0, _react.useMemo)(() => {
    return [...field.value];
  }, [field]);
  const getSelectTactic = (0, _react.useCallback)((threat, index, disabled) => {
    const tacticName = threat.tactic.name;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      id: "mitreAttackTactic",
      options: [...(tacticName === 'none' ? [{
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.TACTIC_PLACEHOLDER),
        value: 'none',
        disabled
      }] : []), ...tacticsOptions.map(t => ({
        inputDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, t.label),
        value: t.value,
        disabled
      }))],
      prepend: `${field.label} ${i18n.TACTIC}`,
      "aria-label": "",
      onChange: updateTactic.bind(null, index),
      fullWidth: true,
      valueOfSelected: (0, _fp.camelCase)(tacticName),
      "data-test-subj": "mitreAttackTactic",
      placeholder: i18n.TACTIC_PLACEHOLDER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "danger",
      iconType: "trash",
      isDisabled: isDisabled || (0, _lodash.isEqual)(values, _default_value.threatDefault),
      onClick: () => removeTactic(index),
      "aria-label": Rulei18n.DELETE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    })));
  }, [field.label, isDisabled, removeTactic, tacticsOptions, updateTactic, values]);

  /**
   * Uses the fieldhook to set a new field value
   *
   * Value is memoized on top level props, any deep changes will have to be new objects
   */
  const onFieldChange = (0, _react.useCallback)(threats => {
    field.setValue(threats);
  }, [field]);
  return /*#__PURE__*/_react.default.createElement(MitreAttackContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, values.map((threat, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, index === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: `${field.label} ${i18n.THREATS}`,
    labelAppend: field.labelAppend,
    describedByIds: idAria ? [`${idAria} ${i18n.TACTIC}`] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, getSelectTactic(threat, index, isDisabled))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    describedByIds: idAria ? [`${idAria} ${i18n.TACTIC}`] : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }, getSelectTactic(threat, index, isDisabled)), /*#__PURE__*/_react.default.createElement(_technique_fields.MitreAttackTechniqueFields, {
    field: field,
    threatIndex: index,
    isDisabled: isDisabled || threat.tactic.name === 'none',
    idAria: idAria,
    onFieldChange: onFieldChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_add_item_form.MyAddItemButton, {
    "data-test-subj": "addMitreAttackTactic",
    onClick: addMitreAttackTactic,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, i18n.ADD_MITRE_TACTIC));
});