"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNotEmptyArray = exports.getQueryLabel = exports.buildUrlsDescription = exports.buildUnorderedListArrayDescription = exports.buildThresholdDescription = exports.buildThreatMappingDescription = exports.buildThreatDescription = exports.buildStringArrayDescription = exports.buildSeverityDescription = exports.buildSetupDescription = exports.buildRuleTypeDescription = exports.buildRiskScoreDescription = exports.buildRequiredFieldsDescription = exports.buildQueryBarDescription = exports.buildNoteDescription = exports.buildIntervalDescription = exports.buildHighlightedFieldsOverrideDescription = exports.buildEqlOptionsDescription = exports.buildAlertSuppressionWindowDescription = exports.buildAlertSuppressionMissingFieldsDescription = exports.buildAlertSuppressionDescription = void 0;
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/unified-search-plugin/public");
var _rule_definition_section = require("../../../rule_management/components/rule_details/rule_definition_section");
var _accessibility = require("../../../../common/components/accessibility");
var _rule_schema = require("../../../../../common/api/detection_engine/model/rule_schema");
var _utility_types = require("../../../../../common/utility_types");
var i18nSeverity = _interopRequireWildcard(require("../severity_mapping/translations"));
var i18nRiskScore = _interopRequireWildcard(require("../risk_score_mapping/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _severity_badge = require("../../../../common/components/severity_badge");
var _types = require("../../../common/types");
var _empty_value = require("../../../../common/components/empty_value");
var _required_field_icon = require("../../../rule_management/components/rule_details/required_field_icon");
var _translations4 = require("../../../rule_management/components/rule_details/translations");
var _helpers = require("../../../rule_management/components/rule_details/helpers");
var _threat_description = require("./threat_description");
var _alert_suppression_label = require("./alert_suppression_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/description_step/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoteDescriptionContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  height: 105px;
  overflow-y: hidden;
`;
const SetupDescriptionContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  height: 105px;
  overflow-y: hidden;
`;
const isNotEmptyArray = values => !(0, _fp.isEmpty)(values.join(''));
exports.isNotEmptyArray = isNotEmptyArray;
const EuiBadgeWrap = (0, _styledComponents.default)(_eui.EuiBadge)`
  .euiBadge__text {
    white-space: pre-wrap !important;
  }
`;
const Query = _styledComponents.default.div`
  white-space: pre-wrap;
`;
const getQueryLabel = ruleType => {
  switch (ruleType) {
    case 'eql':
      return i18n.EQL_QUERY_LABEL;
    case 'saved_query':
      return i18n.SAVED_QUERY_LABEL;
    case 'esql':
      return i18n.ESQL_QUERY_LABEL;
    default:
      return i18n.QUERY_LABEL;
  }
};
exports.getQueryLabel = getQueryLabel;
const buildQueryBarDescription = ({
  field,
  filters,
  filterManager,
  query,
  queryLanguage,
  savedId,
  savedQueryName,
  indexPatterns,
  queryLabel
}) => {
  const items = [];
  const isLoadedFromSavedQuery = !(0, _fp.isEmpty)(savedId) && !(0, _fp.isEmpty)(savedQueryName);
  if (isLoadedFromSavedQuery) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SAVED_QUERY_NAME_LABEL, " "),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, savedQueryName, " ")
    });
  }
  if (!(0, _fp.isEmpty)(filters)) {
    filterManager.setFilters(filters);
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoadedFromSavedQuery ? i18n.SAVED_QUERY_FILTERS_LABEL : i18n.FILTERS_LABEL, " "),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 9
        }
      }, filterManager.getFilters().map((filter, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${field}-filter-${index}`,
        css: {
          width: '100%'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      }, indexPatterns != null ? /*#__PURE__*/_react.default.createElement(_public.FilterBadgeGroup, {
        filters: [filter],
        dataViews: [indexPatterns],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 19
        }
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 19
        }
      })))))
    });
  }
  if (!(0, _fp.isEmpty)(query)) {
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoadedFromSavedQuery ? i18n.SAVED_QUERY_LABEL : queryLabel !== null && queryLabel !== void 0 ? queryLabel : i18n.QUERY_LABEL),
      description: /*#__PURE__*/_react.default.createElement(Query, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 20
        }
      }, query)
    });
  }
  if (queryLanguage) {
    items.push({
      title: _translations4.THREAT_QUERY_LANGUAGE_LABEL,
      description: (0, _helpers.getQueryLanguageLabel)(queryLanguage)
    });
  }
  return items;
};
exports.buildQueryBarDescription = buildQueryBarDescription;
const buildEqlOptionsDescription = eqlOptions => {
  let items = [];
  if (!(0, _fp.isEmpty)(eqlOptions.eventCategoryField)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EQL_EVENT_CATEGORY_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eqlOptions.eventCategoryField)
    }];
  }
  if (!(0, _fp.isEmpty)(eqlOptions.tiebreakerField)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EQL_TIEBREAKER_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eqlOptions.tiebreakerField)
    }];
  }
  if (!(0, _fp.isEmpty)(eqlOptions.timestampField)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EQL_TIMESTAMP_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eqlOptions.timestampField)
    }];
  }
  return items;
};
exports.buildEqlOptionsDescription = buildEqlOptionsDescription;
const buildThreatDescription = ({
  threat,
  label
}) => {
  if (threat.length > 0) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_threat_description.ThreatEuiFlexGroup, {
        threat: threat,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 22
        }
      })
    }];
  }
  return [];
};
exports.buildThreatDescription = buildThreatDescription;
const buildUnorderedListArrayDescription = (label, field, values) => {
  if (isNotEmptyArray(values)) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 13
        }
      }, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement("li", {
        "data-test-subj": "unorderedListArrayDescriptionItem",
        key: `${field}-${val}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 19
        }
      }, val))))
    }];
  }
  return [];
};
exports.buildUnorderedListArrayDescription = buildUnorderedListArrayDescription;
const buildHighlightedFieldsOverrideDescription = (label, values) => {
  if ((0, _fp.isEmpty)(values)) {
    return [];
  }
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 5
    }
  }, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${label}-${val}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
    "data-test-subj": "customHighlightedFieldsStringArrayDescriptionBadgeItem",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, val))));
  return [{
    title: label,
    description
  }];
};
exports.buildHighlightedFieldsOverrideDescription = buildHighlightedFieldsOverrideDescription;
const buildStringArrayDescription = (label, field, values) => {
  if (isNotEmptyArray(values)) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        gutterSize: "xs",
        wrap: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 11
        }
      }, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${field}-${val}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
        "data-test-subj": "stringArrayDescriptionBadgeItem",
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 19
        }
      }, val))))
    }];
  }
  return [];
};
exports.buildStringArrayDescription = buildStringArrayDescription;
const OverrideColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 125px;
  max-width: 125px;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const OverrideValueColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 30px;
  max-width: 30px;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const buildSeverityDescription = severity => [{
  title: i18nSeverity.DEFAULT_SEVERITY,
  description: /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: severity.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 18
    }
  })
}, ...(severity.isMappingChecked ? severity.mapping.filter(severityItem => severityItem.field !== '').map((severityItem, index) => {
  return {
    title: index === 0 ? i18nSeverity.SEVERITY_MAPPING : '',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(OverrideColumn, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: severityItem.field,
      "data-test-subj": `severityOverrideField${index}`,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 316,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 21
      }
    }, `${severityItem.field}:`))), /*#__PURE__*/_react.default.createElement(OverrideValueColumn, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: severityItem.value,
      "data-test-subj": `severityOverrideValue${index}`,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 21
      }
    }, (0, _empty_value.defaultToEmptyTag)(severityItem.value)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 333,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sortRight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      "data-test-subj": `severityOverrideSeverity${index}`,
      value: severityItem.severity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 19
      }
    })))
  };
}) : [])];
exports.buildSeverityDescription = buildSeverityDescription;
const buildRiskScoreDescription = riskScore => [{
  title: i18nRiskScore.RISK_SCORE,
  description: riskScore.value
}, ...(riskScore.isMappingChecked ? riskScore.mapping.filter(riskScoreItem => riskScoreItem.field !== '').map((riskScoreItem, index) => {
  return {
    title: index === 0 ? i18nRiskScore.RISK_SCORE_MAPPING : '',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 361,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(OverrideColumn, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: riskScoreItem.field,
      "data-test-subj": `riskScoreOverrideField${index}`,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 21
      }
    }, riskScoreItem.field))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortRight',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 17
      }
    }, _ruleDataUtils.ALERT_RISK_SCORE))
  };
}) : [])];
exports.buildRiskScoreDescription = buildRiskScoreDescription;
const MyRefUrlLink = (0, _styledComponents.default)(_eui.EuiLink)`
  word-break: break-word;
`;
const buildUrlsDescription = (label, values) => {
  if (isNotEmptyArray(values)) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 13
        }
      }, values.filter(v => !(0, _fp.isEmpty)(v)).map((val, index) => /*#__PURE__*/_react.default.createElement("li", {
        "data-test-subj": "urlsDescriptionReferenceLinkItem",
        key: `${index}-${val}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(MyRefUrlLink, {
        href: val,
        external: true,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 21
        }
      }, val)))))
    }];
  }
  return [];
};
exports.buildUrlsDescription = buildUrlsDescription;
const buildNoteDescription = (label, note) => {
  if (note.trim() !== '') {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(NoteDescriptionContainer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 418,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "noteDescriptionItem",
        className: "eui-yScrollWithShadows",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 419,
          columnNumber: 13
        }
      }, note))
    }];
  }
  return [];
};
exports.buildNoteDescription = buildNoteDescription;
const buildRuleTypeDescription = (label, ruleType) => {
  switch (ruleType) {
    case 'machine_learning':
      {
        return [{
          title: label,
          description: i18n.ML_TYPE_DESCRIPTION
        }];
      }
    case 'query':
    case 'saved_query':
      {
        return [{
          title: label,
          description: i18n.QUERY_TYPE_DESCRIPTION
        }];
      }
    case 'threshold':
      {
        return [{
          title: label,
          description: i18n.THRESHOLD_TYPE_DESCRIPTION
        }];
      }
    case 'eql':
      {
        return [{
          title: label,
          description: i18n.EQL_TYPE_DESCRIPTION
        }];
      }
    case 'threat_match':
      {
        return [{
          title: label,
          description: i18n.THREAT_MATCH_TYPE_DESCRIPTION
        }];
      }
    case 'new_terms':
      {
        return [{
          title: label,
          description: i18n.NEW_TERMS_TYPE_DESCRIPTION
        }];
      }
    case 'esql':
      {
        return [{
          title: label,
          description: i18n.ESQL_TYPE_DESCRIPTION
        }];
      }
    default:
      return (0, _utility_types.assertUnreachable)(ruleType);
  }
};
exports.buildRuleTypeDescription = buildRuleTypeDescription;
const buildThresholdDescription = (label, threshold) => {
  var _threshold$cardinalit, _threshold$cardinalit2;
  let thresholdDescription = (0, _fp.isEmpty)(threshold.field[0]) ? `${i18n.THRESHOLD_RESULTS_ALL} >= ${threshold.value}` : `${i18n.THRESHOLD_RESULTS_AGGREGATED_BY} ${threshold.field.join(',')} >= ${threshold.value}`;
  if ((_threshold$cardinalit = threshold.cardinality) !== null && _threshold$cardinalit !== void 0 && _threshold$cardinalit.value && ((_threshold$cardinalit2 = threshold.cardinality) === null || _threshold$cardinalit2 === void 0 ? void 0 : _threshold$cardinalit2.field.length) > 0) {
    thresholdDescription = i18n.THRESHOLD_CARDINALITY(thresholdDescription, threshold.cardinality.field[0], threshold.cardinality.value);
  }
  return [{
    title: label,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, thresholdDescription)
  }];
};
exports.buildThresholdDescription = buildThresholdDescription;
const buildThreatMappingDescription = (title, threatMapping) => {
  const description = (0, _rule_definition_section.constructThreatMappingDescription)(threatMapping);
  return [{
    title,
    description
  }];
};
exports.buildThreatMappingDescription = buildThreatMappingDescription;
const FieldTypeText = (0, _styledComponents.default)(_eui.EuiText)`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
  display: inline;
`;
const buildRequiredFieldsDescription = (label, requiredFields) => {
  if ((0, _fp.isEmpty)(requiredFields)) {
    return [];
  }
  return [{
    title: label,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 550,
        columnNumber: 9
      }
    }, requiredFields.map((rF, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 552,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 553,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 554,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_required_field_icon.RequiredFieldIcon, {
      "data-test-subj": "field-type-icon",
      type: rF.type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 555,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 557,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(FieldTypeText, {
      grow: false,
      size: 's',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 558,
        columnNumber: 19
      }
    }, ` ${rF.name}${index + 1 !== requiredFields.length ? ', ' : ''}`))))))
  }];
};
exports.buildRequiredFieldsDescription = buildRequiredFieldsDescription;
const buildAlertSuppressionDescription = (label = i18n.ALERT_SUPPRESSION_LABEL, values, ruleType) => {
  if ((0, _fp.isEmpty)(values)) {
    return [];
  }
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 5
    }
  }, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${label}-${val}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
    "data-test-subj": "stringArrayDescriptionBadgeItem",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 584,
      columnNumber: 13
    }
  }, val))));
  const title = /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
    label: label,
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 593,
      columnNumber: 17
    }
  });
  return [{
    title,
    description
  }];
};
exports.buildAlertSuppressionDescription = buildAlertSuppressionDescription;
const buildAlertSuppressionWindowDescription = (label, value, alertSuppressionDuration, ruleType) => {
  const description = alertSuppressionDuration === _types.AlertSuppressionDurationType.PerTimePeriod ? `${value.value}${value.unit}` : i18n.ALERT_SUPPRESSION_PER_RULE_EXECUTION;
  const title = /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
    label: label,
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 613,
      columnNumber: 17
    }
  });
  return [{
    title,
    description
  }];
};
exports.buildAlertSuppressionWindowDescription = buildAlertSuppressionWindowDescription;
const buildAlertSuppressionMissingFieldsDescription = (label, value, ruleType) => {
  if ((0, _fp.isEmpty)(value)) {
    return [];
  }
  const description = value === _rule_schema.AlertSuppressionMissingFieldsStrategyEnum.suppress ? i18n.ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS : i18n.ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS;
  const title = /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
    label: label,
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 636,
      columnNumber: 17
    }
  });
  return [{
    title,
    description
  }];
};
exports.buildAlertSuppressionMissingFieldsDescription = buildAlertSuppressionMissingFieldsDescription;
const buildSetupDescription = (label, setup) => {
  if (setup.trim() !== '') {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(SetupDescriptionContainer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 651,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "setupDescriptionItem",
        className: "eui-yScrollWithShadows",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 652,
          columnNumber: 13
        }
      }, setup))
    }];
  }
  return [];
};
exports.buildSetupDescription = buildSetupDescription;
const buildIntervalDescription = (label, value) => {
  return [{
    title: label,
    description: /*#__PURE__*/_react.default.createElement(_accessibility.IntervalAbbrScreenReader, {
      interval: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 667,
        columnNumber: 20
      }
    })
  }];
};
exports.buildIntervalDescription = buildIntervalDescription;