"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _integrations_description = require("../integrations_description");
var _use_related_integrations = require("../use_related_integrations");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/common/components/related_integrations/integrations_popover/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IntegrationsPopoverWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  width: 100%;
`;
const PopoverTitleWrapper = (0, _styledComponents.default)(_eui.EuiPopoverTitle)`
  max-width: 390px;
`;
const PopoverContentWrapper = (0, _styledComponents.default)('div')`
  max-height: 400px;
  max-width: 390px;
  overflow: auto;
  line-height: ${({
  theme
}) => theme.eui.euiLineHeight};
`;
const IntegrationListItem = (0, _styledComponents.default)('li')`
  list-style-type: disc;
  margin-left: 25px;
  margin-bottom: 5px;
`;

/**
 * Component to render installed and available integrations
 * @param integrations - array of integrations to display
 */
const IntegrationsPopoverComponent = ({
  relatedIntegrations
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const {
    integrations,
    isLoaded
  } = (0, _use_related_integrations.useRelatedIntegrations)(relatedIntegrations);
  const enabledIntegrations = (0, _react.useMemo)(() => {
    return integrations.filter(i => i.installationStatus.isKnown && i.installationStatus.isEnabled);
  }, [integrations]);
  const numIntegrations = integrations.length;
  const numIntegrationsEnabled = enabledIntegrations.length;
  const badgeTitle = (0, _react.useMemo)(() => isLoaded ? `${numIntegrationsEnabled}/${numIntegrations}` : `${numIntegrations}`, [isLoaded, numIntegrations, numIntegrationsEnabled]);
  return /*#__PURE__*/_react.default.createElement(IntegrationsPopoverWrapper, {
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": 'IntegrationsWrapper',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    "data-test-subj": 'IntegrationsDisplayPopover',
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: 'package',
      color: "hollow",
      "data-test-subj": 'IntegrationsDisplayPopoverButton',
      onClick: () => setPopoverOpen(!isPopoverOpen),
      onClickAriaLabel: badgeTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, badgeTitle),
    isOpen: isPopoverOpen,
    closePopover: () => setPopoverOpen(!isPopoverOpen),
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(PopoverTitleWrapper, {
    "data-test-subj": 'IntegrationsPopoverTitle',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, i18n.INTEGRATIONS_POPOVER_TITLE(numIntegrations)), /*#__PURE__*/_react.default.createElement(PopoverContentWrapper, {
    "data-test-subj": 'IntegrationsPopoverContentWrapper',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, i18n.INTEGRATIONS_POPOVER_DESCRIPTION(numIntegrations)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, integrations.map((integration, index) => /*#__PURE__*/_react.default.createElement(IntegrationListItem, {
    key: `${integration.packageName}-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_integrations_description.IntegrationDescription, {
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  })))))));
};
const MemoizedIntegrationsPopover = /*#__PURE__*/_react.default.memo(IntegrationsPopoverComponent);
MemoizedIntegrationsPopover.displayName = 'IntegrationsPopover';
const IntegrationsPopover = exports.IntegrationsPopover = MemoizedIntegrationsPopover;