"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDefaultDataView = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _model = require("../../sourcerer/store/model");
var _create_sourcerer_data_view = require("../../sourcerer/containers/create_sourcerer_data_view");
var _constants = require("../../../common/constants");
var _helpers_access = require("../../helpers_access");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDefaultDataView = async ({
  uiSettings,
  dataViewService,
  spaces,
  skip = false,
  http,
  application,
  attacksAlertsAlignmentEnabled = false
}) => {
  const configPatternList = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  let defaultDataView;
  let alertDataView;
  let attackDataView;
  let kibanaDataViews;
  let signal = {
    name: null,
    index_mapping_outdated: null
  };
  if (skip) {
    return {
      kibanaDataViews: [],
      defaultDataView: {
        ..._model.initDataView
      },
      alertDataView: {
        ..._model.initDataView
      },
      attackDataView: {
        ..._model.initDataView
      },
      signal
    };
  }
  try {
    var _await$spaces$getActi, _signal$name;
    if ((0, _helpers_access.hasAccessToSecuritySolution)(application.capabilities)) {
      signal = await http.fetch(_constants.DETECTION_ENGINE_INDEX_URL, {
        version: '2023-10-31',
        method: 'GET'
      });
    }
    const currentSpaceId = (_await$spaces$getActi = await (spaces === null || spaces === void 0 ? void 0 : spaces.getActiveSpace())) === null || _await$spaces$getActi === void 0 ? void 0 : _await$spaces$getActi.id;

    // check for/generate default Security Solution Kibana data view
    const sourcererDataView = await (0, _create_sourcerer_data_view.createSourcererDataView)({
      dataViewService,
      defaultDetails: {
        dataViewId: `${_constants.DEFAULT_DATA_VIEW_ID}-${currentSpaceId}`,
        patternList: [...configPatternList, ...(signal.name != null ? [signal.name] : [])]
      },
      alertDetails: {
        dataViewId: `${_constants.DEFAULT_ALERT_DATA_VIEW_ID}-${currentSpaceId}`,
        indexName: (_signal$name = signal.name) !== null && _signal$name !== void 0 ? _signal$name : undefined
      },
      ...(attacksAlertsAlignmentEnabled && {
        attackDetails: {
          dataViewId: `${_constants.DEFAULT_ATTACK_DATA_VIEW_ID}-${currentSpaceId}`,
          patternList: [`${_elasticAssistantCommon.ATTACK_DISCOVERY_ALERTS_COMMON_INDEX_PREFIX}-${currentSpaceId}`, ...(signal.name != null ? [signal.name] : [])]
        }
      })
    });
    if (sourcererDataView === undefined) {
      throw new Error('');
    }
    defaultDataView = {
      ..._model.initDataView,
      ...sourcererDataView.defaultDataView
    };
    alertDataView = {
      ..._model.initDataView,
      ...sourcererDataView.alertDataView
    };
    attackDataView = {
      ..._model.initDataView,
      ...sourcererDataView.attackDataView
    };
    kibanaDataViews = sourcererDataView.kibanaDataViews.map(dataView => ({
      ..._model.initDataView,
      ...dataView
    }));
  } catch (error) {
    defaultDataView = {
      ..._model.initDataView,
      error
    };
    alertDataView = {
      ..._model.initDataView,
      error
    };
    attackDataView = {
      ..._model.initDataView,
      error
    };
    kibanaDataViews = [];
  }
  return {
    kibanaDataViews,
    defaultDataView,
    alertDataView,
    attackDataView,
    signal
  };
};
exports.createDefaultDataView = createDefaultDataView;