"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelectDataView = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _actions = require("../redux/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook wraps the dispatch call that updates the redux store with new data view selection.
 * It is the recommended entry point for altering the data view selection.
 * Manual action dispatches are not required and should be avoided outside of the data view manager scope.
 * Note: it will not select anything if neither params.id or params.fallbackPatterns are set.
 */
const useSelectDataView = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return (0, _react.useCallback)(params => {
    var _params$fallbackPatte;
    if (!(params.id || (_params$fallbackPatte = params.fallbackPatterns) !== null && _params$fallbackPatte !== void 0 && _params$fallbackPatte.length)) {
      return;
    }
    dispatch((0, _actions.selectDataViewAsync)(params));
  }, [dispatch]);
};
exports.useSelectDataView = useSelectDataView;