"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.depsStartMock = void 0;
var _mocks = require("@kbn/data-plugin/public/mocks");
var _mocks2 = require("@kbn/fleet-plugin/public/mocks");
var _mocks3 = require("@kbn/unified-search-plugin/public/mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type for our app's depsStart (plugin start dependencies)
 */

/**
 * Returns a mock of our app's depsStart (plugin start dependencies)
 */
const depsStartMock = () => {
  const dataMock = _mocks.dataPluginMock.createStartContract();
  dataMock.dataViews.getFieldsForWildcard = jest.fn();
  dataMock.query.filterManager.setFilters = jest.fn();
  dataMock.query.filterManager.getUpdates$ = jest.fn(() => {
    return {
      subscribe: jest.fn(() => {
        return {
          unsubscribe: jest.fn()
        };
      })
    };
  });
  return {
    data: dataMock,
    unifiedSearch: _mocks3.unifiedSearchPluginMock.createStartContract(),
    fleet: _mocks2.fleetMock.createStartMock()
  };
};
exports.depsStartMock = depsStartMock;