"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEnhancedIntegrationCards = exports.getCategoryBadgeIfAny = exports.applyCategoryBadgeAndStyling = exports.FEATURED_INTEGRATION_SORT_ORDER = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("../../../../../../common/constants");
var _constants2 = require("../../../../../configurations/constants");
var _constants3 = require("./constants");
var _constants4 = require("../../../integrations/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/lib/search_ai_lake/hooks/integrations/use_enhanced_integration_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FEATURED_INTEGRATION_SORT_ORDER = exports.FEATURED_INTEGRATION_SORT_ORDER = ['epr:splunk', 'epr:google_secops', 'epr:microsoft_sentinel', 'epr:sentinel_one', 'epr:crowdstrike', 'epr:elastic_security'];
const INTEGRATION_CARD_MIN_HEIGHT_PX = 88;
const addPathParamToUrl = (url, path) => {
  if (!path) {
    return url;
  }
  const encodedPath = encodeURIComponent(path);
  const paramsString = `${_constants3.RETURN_APP_ID}=${_securitySolutionNavigation.SECURITY_UI_APP_ID}&${_constants3.RETURN_PATH}=${encodedPath}`;
  if (url.indexOf('?') >= 0) {
    return `${url}&${paramsString}`;
  }
  return `${url}?${paramsString}`;
};
const getCategoryBadgeIfAny = categories => {
  return categories.includes('edr_xdr') ? 'EDR/XDR' : categories.includes('siem') ? 'SIEM' : null;
};
exports.getCategoryBadgeIfAny = getCategoryBadgeIfAny;
const applyCategoryBadgeAndStyling = (card, options) => {
  const url = addPathParamToUrl(card.url, options === null || options === void 0 ? void 0 : options.returnPath);
  const categoryBadge = getCategoryBadgeIfAny(card.categories);
  return {
    ...card,
    titleLineClamp: _constants4.CARD_TITLE_LINE_CLAMP,
    url,
    showInstallationStatus: options === null || options === void 0 ? void 0 : options.showInstallationStatus,
    showCompressedInstallationStatus: options === null || options === void 0 ? void 0 : options.showCompressedInstallationStatus,
    showDescription: false,
    showReleaseBadge: false,
    extraLabelsBadges: categoryBadge ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }, categoryBadge)))] : [],
    minCardHeight: INTEGRATION_CARD_MIN_HEIGHT_PX,
    hasDataStreams: options === null || options === void 0 ? void 0 : options.hasDataStreams
  };
};
exports.applyCategoryBadgeAndStyling = applyCategoryBadgeAndStyling;
const applyCustomDisplayOrder = integrationsList => {
  return integrationsList.sort((a, b) => FEATURED_INTEGRATION_SORT_ORDER.indexOf(a.id) - FEATURED_INTEGRATION_SORT_ORDER.indexOf(b.id));
};
const useEnhancedIntegrationCards = (integrationsList, activeIntegrations = [], options) => {
  const sorted = applyCustomDisplayOrder(integrationsList);
  const available = (0, _react.useMemo)(() => sorted.map(card => {
    var _options$returnPath;
    return applyCategoryBadgeAndStyling(card, {
      ...options,
      hasDataStreams: activeIntegrations.some(({
        name
      }) => name === card.name),
      returnPath: (_options$returnPath = options === null || options === void 0 ? void 0 : options.returnPath) !== null && _options$returnPath !== void 0 ? _options$returnPath : `${_constants.CONFIGURATIONS_PATH}/integrations/${_constants2.IntegrationsFacets.available}`
    });
  }), [sorted, options, activeIntegrations]);
  const installed = (0, _react.useMemo)(() => sorted.map(card => applyCategoryBadgeAndStyling(card, {
    ...options,
    returnPath: `${_constants.CONFIGURATIONS_PATH}/integrations/${_constants2.IntegrationsFacets.installed}`
  })).filter(card => card.installStatus === _public.installationStatuses.Installed || card.installStatus === _public.installationStatuses.InstallFailed), [sorted, options]);
  return {
    available,
    installed
  };
};
exports.useEnhancedIntegrationCards = useEnhancedIntegrationCards;