"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataViewId = void 0;
var _reactRedux = require("react-redux");
var _selectors = require("../../sourcerer/store/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataViewId = scopeId => {
  const dataViewId = (0, _reactRedux.useSelector)(state => (0, _selectors.sourcererScopeSelectedDataViewId)(state, scopeId));
  return dataViewId !== null && dataViewId !== void 0 ? dataViewId : undefined;
};
exports.useDataViewId = useDataViewId;