"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ERROR_FETCH_AI_CONNECTORS = exports.ADDED_TO_TIMELINE_TEMPLATE_MESSAGE = exports.ADDED_TO_TIMELINE_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADDED_TO_TIMELINE_MESSAGE = fieldOrValue => _i18n.i18n.translate('xpack.securitySolution.hooks.useAddToTimeline.addedFieldMessage', {
  values: {
    fieldOrValue
  },
  defaultMessage: `Added {fieldOrValue} to timeline`
});
exports.ADDED_TO_TIMELINE_MESSAGE = ADDED_TO_TIMELINE_MESSAGE;
const ADDED_TO_TIMELINE_TEMPLATE_MESSAGE = fieldOrValue => _i18n.i18n.translate('xpack.securitySolution.hooks.useAddToTimeline.template.addedFieldMessage', {
  values: {
    fieldOrValue
  },
  defaultMessage: `Added {fieldOrValue} to timeline template`
});
exports.ADDED_TO_TIMELINE_TEMPLATE_MESSAGE = ADDED_TO_TIMELINE_TEMPLATE_MESSAGE;
const ERROR_FETCH_AI_CONNECTORS = exports.ERROR_FETCH_AI_CONNECTORS = _i18n.i18n.translate('xpack.securitySolution.hooks.useGetAIConnectors.fetchError', {
  defaultMessage: 'Error fetching AI connectors'
});